/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.api.observation;

import java.rmi.RemoteException;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.services.jcr.rmi.api.observation.Queue;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteAdapterFactory;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteEventCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerEventListenerProxy
implements EventListener {
    private static final Logger log = LoggerFactory.getLogger(ServerEventListenerProxy.class);
    private final RemoteAdapterFactory factory;
    private final long listenerId;
    private final Queue queue;

    public ServerEventListenerProxy(RemoteAdapterFactory factory, long listenerId, Queue queue) {
        this.factory = factory;
        this.listenerId = listenerId;
        this.queue = queue;
    }

    public void onEvent(EventIterator events) {
        try {
            RemoteEventCollection remoteEvent = this.factory.getRemoteEvent(this.listenerId, events);
            this.queue.put(remoteEvent);
        }
        catch (RemoteException re) {
            Throwable t = re.getCause() == null ? re : re.getCause();
            log.error("Problem creating remote event for " + this.listenerId, t);
        }
    }

    public int hashCode() {
        return (int)this.listenerId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServerEventListenerProxy) {
            return this.listenerId == ((ServerEventListenerProxy)obj).listenerId;
        }
        return false;
    }

    public String toString() {
        return "EventListenerProxy: listenerId=" + this.listenerId;
    }
}

