/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.api.client;

import java.rmi.RemoteException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.services.jcr.rmi.api.client.ClientItemDefinition;
import org.exoplatform.services.jcr.rmi.api.client.LocalAdapterFactory;
import org.exoplatform.services.jcr.rmi.api.exceptions.RemoteRuntimeException;
import org.exoplatform.services.jcr.rmi.api.remote.nodetype.RemoteNodeDefinition;
import org.exoplatform.services.jcr.rmi.api.remote.nodetype.RemoteNodeType;

public class ClientNodeDefinition
extends ClientItemDefinition
implements NodeDefinition {
    private RemoteNodeDefinition remote;

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof ClientNodeDefinition) {
            ClientNodeDefinition cnodedef = (ClientNodeDefinition)obj;
            return this.allowsSameNameSiblings() && cnodedef.allowsSameNameSiblings() && this.getDefaultPrimaryType().equals(cnodedef.getDefaultPrimaryType()) && ClientNodeDefinition.equalsNodeTypeArray(this.getRequiredPrimaryTypes(), cnodedef.getRequiredPrimaryTypes());
        }
        return false;
    }

    public ClientNodeDefinition(RemoteNodeDefinition remote, LocalAdapterFactory factory) {
        super(remote, factory);
        this.remote = remote;
    }

    public NodeType[] getRequiredPrimaryTypes() {
        try {
            return this.getNodeTypeArray(this.remote.getRequiredPrimaryTypes());
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public NodeType getDefaultPrimaryType() {
        try {
            RemoteNodeType nt = this.remote.getDefaultPrimaryType();
            if (nt == null) {
                return null;
            }
            return this.getFactory().getNodeType(nt);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean allowsSameNameSiblings() {
        try {
            return this.remote.allowsSameNameSiblings();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public static boolean equalsNodeTypeArray(NodeType[] a, NodeType[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        boolean equal = true;
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(b[i])) continue;
            equal = false;
        }
        return equal;
    }
}

