/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.impl.server;

import java.rmi.RemoteException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteQuery;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteQueryManager;
import org.exoplatform.services.jcr.rmi.impl.server.RemoteAdapterFactoryImpl;
import org.exoplatform.services.jcr.rmi.impl.server.ServerObject;

public class ServerQueryManager
extends ServerObject
implements RemoteQueryManager {
    private static final long serialVersionUID = 8912932186044455036L;
    private QueryManager manager;
    private Session session;

    public ServerQueryManager(QueryManager manager, RemoteAdapterFactoryImpl factory, Session session) throws RemoteException {
        super(factory);
        this.session = session;
        this.manager = manager;
    }

    public RemoteQuery createQuery(String statement, String language) throws RepositoryException, RemoteException {
        try {
            Query query = this.manager.createQuery(statement, language);
            return this.getFactory().getRemoteQuery(query);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteQuery getQuery(String absPath) throws RepositoryException, RemoteException {
        try {
            Node node = (Node)this.session.getItem(absPath);
            return this.getFactory().getRemoteQuery(this.manager.getQuery(node));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public String[] getSupportedQueryLanguages() throws RepositoryException, RemoteException {
        try {
            return this.manager.getSupportedQueryLanguages();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }
}

