/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.impl.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.QueryManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteAdapterFactory;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteNamespaceRegistry;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteObservationManager;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteQueryManager;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteWorkspace;
import org.exoplatform.services.jcr.rmi.api.remote.nodetype.RemoteNodeTypeManager;
import org.exoplatform.services.jcr.rmi.impl.server.ServerObject;

public class ServerWorkspace
extends ServerObject
implements RemoteWorkspace {
    private static final long serialVersionUID = 7047140615388378488L;
    private Workspace workspace;
    private RemoteObservationManager remoteObservationManager;

    public ServerWorkspace(Workspace workspace, RemoteAdapterFactory factory) throws RemoteException {
        super(factory);
        this.workspace = workspace;
    }

    public String getName() throws RemoteException {
        return this.workspace.getName();
    }

    public void copy(String from, String to) throws RepositoryException, RemoteException {
        try {
            this.workspace.copy(from, to);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void copy(String workspace, String from, String to) throws RepositoryException, RemoteException {
        try {
            this.workspace.copy(workspace, from, to);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void clone(String workspace, String from, String to, boolean removeExisting) throws RepositoryException, RemoteException {
        try {
            this.workspace.clone(workspace, from, to, removeExisting);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void move(String from, String to) throws RepositoryException, RemoteException {
        try {
            this.workspace.move(from, to);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteNodeTypeManager getNodeTypeManager() throws RepositoryException, RemoteException {
        try {
            NodeTypeManager manager = this.workspace.getNodeTypeManager();
            return this.getFactory().getRemoteNodeTypeManager(manager);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteNamespaceRegistry getNamespaceRegistry() throws RepositoryException, RemoteException {
        try {
            NamespaceRegistry registry = this.workspace.getNamespaceRegistry();
            return this.getFactory().getRemoteNamespaceRegistry(registry);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteQueryManager getQueryManager() throws RepositoryException, RemoteException {
        try {
            QueryManager queryManager = this.workspace.getQueryManager();
            return this.getFactory().getRemoteQueryManager(queryManager, this.workspace.getSession());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteObservationManager getObservationManager() throws RepositoryException, RemoteException {
        try {
            if (this.remoteObservationManager == null) {
                ObservationManager observationManager = this.workspace.getObservationManager();
                this.remoteObservationManager = this.getFactory().getRemoteObservationManager(observationManager);
            }
            return this.remoteObservationManager;
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException, RemoteException {
        try {
            return this.workspace.getAccessibleWorkspaceNames();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void importXML(String path, byte[] xml, int uuidBehaviour) throws IOException, RepositoryException, RemoteException {
        try {
            this.workspace.importXML(path, (InputStream)new ByteArrayInputStream(xml), uuidBehaviour);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void restore(String[] versionUuids, boolean removeExisting) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException, RemoteException {
        if (versionUuids != null) {
            Version[] versions = new Version[versionUuids.length];
            for (int i = 0; i < versionUuids.length; ++i) {
                versions[i] = (Version)this.workspace.getSession().getNodeByUUID(versionUuids[i]);
            }
            this.workspace.restore(versions, removeExisting);
        }
    }
}

