/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.api.client;

import java.rmi.RemoteException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.exoplatform.services.jcr.rmi.api.client.ClientObject;
import org.exoplatform.services.jcr.rmi.api.client.LocalAdapterFactory;
import org.exoplatform.services.jcr.rmi.api.exceptions.RemoteRepositoryException;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteQueryResult;

public class ClientQueryResult
extends ClientObject
implements QueryResult {
    private Session session;
    private RemoteQueryResult remote;

    public ClientQueryResult(Session session, RemoteQueryResult remote, LocalAdapterFactory factory) {
        super(factory);
        this.session = session;
        this.remote = remote;
    }

    public String[] getColumnNames() throws RepositoryException {
        try {
            return this.remote.getColumnNames();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public RowIterator getRows() throws RepositoryException {
        try {
            return this.getFactory().getRowIterator(this.remote.getRows());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public NodeIterator getNodes() throws RepositoryException {
        try {
            return this.getFactory().getNodeIterator(this.session, this.remote.getNodes());
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
    }
}

