/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.command;

import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.HeaderParam;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.ResourceDispatcher;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.transformer.PassthroughInputTransformer;
import org.exoplatform.services.rest.transformer.PassthroughOutputTransformer;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.common.command.WebDavCommand;
import org.exoplatform.services.webdav.common.resource.JCRResourceDispatcher;

@URITemplate(value="/jcr/")
public class DeleteCommand
extends WebDavCommand {
    public DeleteCommand(WebDavService webDavService, ResourceDispatcher resourceDispatcher, ThreadLocalSessionProviderService sessionProviderService) {
        super(webDavService, resourceDispatcher, sessionProviderService);
    }

    @HTTPMethod(value="DELETE")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response delete(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="Authorization") String authorization, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        try {
            ArrayList<String> lockTokens = this.getLockTokens(lockTokenHeader, ifHeader);
            SessionProvider sessionProvider = this.getSessionProvider(authorization);
            ManageableRepository repository = this.webDavService.getRepository(repoName);
            Item item = new JCRResourceDispatcher(sessionProvider, repository).getItem(repoPath);
            this.tuneSession(item.getSession(), lockTokens);
            if (!(item instanceof Node)) {
                throw new AccessDeniedException();
            }
            Node node = (Node)item;
            if ("/".equals(node.getPath())) {
                throw new AccessDeniedException();
            }
            node.remove();
            node.getSession().save();
            sessionProvider.close();
            return Response.Builder.withStatus((int)204).build();
        }
        catch (Exception exc) {
            return this.responseByException(exc);
        }
    }
}

