/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.command;

import java.util.HashMap;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.version.Version;
import javax.xml.transform.stream.StreamSource;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.HeaderParam;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.ResourceDispatcher;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.transformer.OutputEntityTransformer;
import org.exoplatform.services.rest.transformer.PassthroughInputTransformer;
import org.exoplatform.services.rest.transformer.PassthroughOutputTransformer;
import org.exoplatform.services.rest.transformer.XSLT4SourceOutputTransformer;
import org.exoplatform.services.rest.transformer.XSLTConstants;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.common.command.WebDavCommand;
import org.exoplatform.services.webdav.common.resource.JCRResourceDispatcher;
import org.exoplatform.services.webdav.common.resource.resourcedata.AbstractResourceData;
import org.exoplatform.services.webdav.common.resource.resourcedata.JcrFileResourceData;
import org.exoplatform.services.webdav.common.resource.resourcedata.JcrPropertyData;
import org.exoplatform.services.webdav.common.resource.resourcedata.ResourceData;
import org.exoplatform.services.webdav.common.resource.resourcedata.XmlItemData;
import org.exoplatform.services.webdav.common.response.RangedInputStream;

@URITemplate(value="/jcr/")
public class GetCommand
extends WebDavCommand {
    public GetCommand(WebDavService webDavService, ResourceDispatcher resourceDispatcher, ThreadLocalSessionProviderService sessionProviderService) {
        super(webDavService, resourceDispatcher, sessionProviderService);
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=XSLT4SourceOutputTransformer.class)
    public Response get(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="Authorization") String authorization, @HeaderParam(value="Range") String rangeHeader, @QueryParam(value="VERSIONID") String versionId) {
        try {
            String rangeString;
            String[] curRanges;
            String serverPrefix = this.getPrefix(repoPath);
            long rangeStart = -1L;
            long rangeEnd = -1L;
            if (rangeHeader != null && rangeHeader.startsWith("bytes=") && (curRanges = (rangeString = rangeHeader.substring(rangeHeader.indexOf("=") + 1)).split("-")).length > 0) {
                rangeStart = new Long(curRanges[0]);
                if (curRanges.length > 1) {
                    rangeEnd = new Long(curRanges[1]);
                }
            }
            SessionProvider sessionProvider = this.getSessionProvider(authorization);
            Item item = new JCRResourceDispatcher(sessionProvider, this.webDavService.getRepository(repoName)).getItem(repoPath);
            AbstractResourceData resourceData = null;
            if (item instanceof Node) {
                Node node = (Node)item;
                if (node.isNodeType("nt:file")) {
                    Node fileNode = node;
                    if (versionId != null) {
                        Version version = node.getVersionHistory().getVersion(versionId);
                        fileNode = version.getNode("jcr:frozenNode");
                    }
                    resourceData = new JcrFileResourceData(fileNode);
                } else {
                    resourceData = new XmlItemData(serverPrefix + "/" + repoPath.split("/")[0], node);
                }
            } else {
                resourceData = new JcrPropertyData((Property)item);
            }
            return this.doGet(resourceData, rangeStart, rangeEnd, rangeHeader != null);
        }
        catch (Exception exc) {
            return this.responseByException(exc);
        }
    }

    private Response doGet(ResourceData resourceData, long startRange, long endRange, boolean isPartial) throws Exception {
        String contentType = resourceData.getContentType();
        long contentLength = resourceData.getContentLength();
        if (resourceData.getContentLength() == 0L) {
            return Response.Builder.ok().header("Content-Length", "0").header("Accept-Ranges", "bytes").entity((Object)resourceData.getContentStream(), contentType).transformer((OutputEntityTransformer)new PassthroughOutputTransformer()).build();
        }
        if (startRange > contentLength - 1L || endRange > contentLength - 1L) {
            return Response.Builder.withStatus((int)416).header("Accept-Ranges", "bytes").entity((Object)resourceData.getContentStream(), contentType).transformer((OutputEntityTransformer)new PassthroughOutputTransformer()).build();
        }
        if (startRange < 0L) {
            startRange = 0L;
        }
        if (endRange < 0L) {
            endRange = contentLength - 1L;
        }
        RangedInputStream rangedInputStream = new RangedInputStream(resourceData.getContentStream(), startRange, endRange);
        if (isPartial) {
            long returnedContentLength = endRange - startRange + 1L;
            return Response.Builder.withStatus((int)206).header("Content-Length", "" + returnedContentLength).header("Accept-Ranges", "bytes").header("Content-Range", "bytes " + startRange + "-" + endRange + "/" + contentLength).entity((Object)rangedInputStream, contentType).transformer((OutputEntityTransformer)new PassthroughOutputTransformer()).build();
        }
        if (resourceData.isCollection()) {
            HashMap<String, String> tp = new HashMap<String, String>();
            tp.put(XSLTConstants.XSLT_TEMPLATE, "get.method.template");
            return Response.Builder.ok().entity((Object)new StreamSource(resourceData.getContentStream()), "text/html").setTransformerParameters(tp).build();
        }
        return Response.Builder.ok().header("Content-Length", "" + resourceData.getContentLength()).header("Accept-Ranges", "bytes").entity((Object)resourceData.getContentStream(), contentType).transformer((OutputEntityTransformer)new PassthroughOutputTransformer()).build();
    }
}

