/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.command;

import java.util.ArrayList;
import javax.jcr.Item;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.HeaderParam;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.ResourceDispatcher;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.transformer.PassthroughInputTransformer;
import org.exoplatform.services.rest.transformer.PassthroughOutputTransformer;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.common.command.NodeTypedCommand;
import org.exoplatform.services.webdav.common.resource.JCRResourceDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@URITemplate(value="/jcr/")
public class MkColCommand
extends NodeTypedCommand {
    private static Log log = ExoLogger.getLogger((String)"jcr.MkColCommand");

    public MkColCommand(WebDavService webDavService, ResourceDispatcher resourceDispatcher, ThreadLocalSessionProviderService sessionProviderService) {
        super(webDavService, resourceDispatcher, sessionProviderService);
    }

    @HTTPMethod(value="MKCOL")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response mkcol(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="Authorization") String authorization, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="NodeType") String nodeTypeHeader, @HeaderParam(value="MixType") String mixinTypesHeader) {
        try {
            ArrayList<String> lockTokens = this.getLockTokens(lockTokenHeader, ifHeader);
            SessionProvider sessionProvider = this.getSessionProvider(authorization);
            String nodeType = this.getNodeType(nodeTypeHeader);
            ArrayList<String> mixinTypes = this.getMixinTypes(mixinTypesHeader);
            try {
                Item item = new JCRResourceDispatcher(sessionProvider, this.webDavService.getRepository(repoName)).getItem(repoPath);
                throw new NoSuchWorkspaceException("Item already present!!!");
            }
            catch (PathNotFoundException pexc) {
                String workspaceName = repoPath.split("/")[0];
                Session session = sessionProvider.getSession(workspaceName, this.webDavService.getRepository(repoName));
                this.tuneSession(session, lockTokens);
                this.createAsCollection(session, repoPath.substring(("/" + workspaceName).length()), nodeType, mixinTypes);
                return Response.Builder.withStatus((int)201).build();
            }
        }
        catch (Exception exc) {
            return this.responseByException(exc);
        }
    }

    public void createAsCollection(Session session, String path, String nodeType, ArrayList<String> mixinTypes) throws RepositoryException {
        int i;
        String workNodeType = nodeType != null ? nodeType : this.webDavService.getConfig().getDefFolderNodeType();
        String[] pathes = path.split("/");
        Node node = session.getRootNode();
        for (i = 0; i < pathes.length; ++i) {
            if ("".equals(pathes[i])) continue;
            node = node.hasNode(pathes[i]) ? node.getNode(pathes[i]) : node.addNode(pathes[i], workNodeType);
        }
        session.save();
        if (mixinTypes != null) {
            for (i = 0; i < mixinTypes.size(); ++i) {
                String curMixinType = mixinTypes.get(i);
                try {
                    node.addMixin(curMixinType);
                    node.getSession().save();
                    continue;
                }
                catch (Exception exc) {
                    log.info((Object)("Can't add mixin [" + curMixinType + "]"));
                }
            }
        }
    }
}

