/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.command;

import java.util.ArrayList;
import javax.jcr.Item;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.HeaderParam;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.ResourceDispatcher;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.transformer.PassthroughOutputTransformer;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.WebDavXmlInputTransformer;
import org.exoplatform.services.webdav.common.command.WebDavCommand;
import org.exoplatform.services.webdav.common.resource.JCRResourceDispatcher;
import org.w3c.dom.Document;

@URITemplate(value="/jcr/")
public class OptionsCommand
extends WebDavCommand {
    public OptionsCommand(WebDavService webDavService, ResourceDispatcher resourceDispatcher, ThreadLocalSessionProviderService sessionProviderService) {
        super(webDavService, resourceDispatcher, sessionProviderService);
    }

    @HTTPMethod(value="OPTIONS")
    @URITemplate(value="/{repoName}/")
    @InputTransformer(value=WebDavXmlInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response options(@URIParam(value="repoName") String repoName, Document document, @HeaderParam(value="Authorization") String authorization) {
        try {
            return this.doOptions();
        }
        catch (Exception exc) {
            return this.responseByException(exc);
        }
    }

    @HTTPMethod(value="OPTIONS")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=WebDavXmlInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response options(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, Document document, @HeaderParam(value="Authorization") String authorization) {
        try {
            SessionProvider sessionProvider = this.getSessionProvider(authorization);
            Item item = new JCRResourceDispatcher(sessionProvider, this.webDavService.getRepository(repoName)).getItem(repoPath);
            return this.doOptions();
        }
        catch (Exception exc) {
            return this.responseByException(exc);
        }
    }

    protected Response doOptions() throws Exception {
        String allowedCommands = "";
        ArrayList<String> availableCommands = this.webDavService.getAvailableCommands();
        for (int i = 0; i < availableCommands.size(); ++i) {
            String curCommand = availableCommands.get(i);
            allowedCommands = allowedCommands + curCommand;
            if (i >= availableCommands.size() - 1) continue;
            allowedCommands = allowedCommands + ", ";
        }
        return Response.Builder.ok().header("Allow", allowedCommands).header("DAV", "1, 2, ordered-collections").header("DASL", "<DAV:basicsearch><exo:sql xmlns:exo=\"http://exoplatform.com/jcr\"/><exo:xpath xmlns:exo=\"http://exoplatform.com/jcr\"/>").header("MS-Author-Via", "DAV").build();
    }
}

