/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.command;

import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.HeaderParam;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.ResourceDispatcher;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.transformer.PassthroughInputTransformer;
import org.exoplatform.services.rest.transformer.PassthroughOutputTransformer;
import org.exoplatform.services.rest.transformer.SerializableTransformer;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.WebDavXmlInputTransformer;
import org.exoplatform.services.webdav.common.command.WebDavCommand;
import org.exoplatform.services.webdav.common.representation.write.PropertyUpdateRepresentationFactory;
import org.exoplatform.services.webdav.common.representation.write.PropertyUpdateResponseRepresentation;
import org.exoplatform.services.webdav.common.resource.JCRResourceDispatcher;
import org.w3c.dom.Document;

@URITemplate(value="/jcr/")
public class PropPatchCommand
extends WebDavCommand {
    public PropPatchCommand(WebDavService webDavService, ResourceDispatcher resourceDispatcher, ThreadLocalSessionProviderService sessionProviderService) {
        super(webDavService, resourceDispatcher, sessionProviderService);
    }

    @HTTPMethod(value="PROPPATCH")
    @URITemplate(value="/{repoName}/")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response proppatch(@URIParam(value="repoName") String repoName) {
        return Response.Builder.withStatus((int)403).build();
    }

    @HTTPMethod(value="PROPPATCH")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=WebDavXmlInputTransformer.class)
    @OutputTransformer(value=SerializableTransformer.class)
    public Response proppatch(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="Authorization") String authorization, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, Document document) {
        try {
            SessionProvider sessionProvider = this.getSessionProvider(authorization);
            ManageableRepository repository = this.webDavService.getRepository(repoName);
            Item item = new JCRResourceDispatcher(sessionProvider, repository).getItem(repoPath);
            if (!(item instanceof Node)) {
                throw new AccessDeniedException();
            }
            ArrayList<String> lockTokens = this.getLockTokens(lockTokenHeader, ifHeader);
            this.tuneSession(item.getSession(), lockTokens);
            String href = this.getHref(repoPath);
            PropertyUpdateResponseRepresentation propertyUpdateRepresentation = PropertyUpdateRepresentationFactory.createResponseRepresentation(this.webDavService, document, item, href);
            return Response.Builder.withStatus((int)207).entity((Object)propertyUpdateRepresentation, "text/xml").build();
        }
        catch (Exception exc) {
            return this.responseByException(exc);
        }
    }
}

