/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.representation;

import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.transformer.SerializableEntity;
import org.exoplatform.services.webdav.common.representation.WebDavNameSpaceContext;

public abstract class XmlResponseRepresentation
implements SerializableEntity {
    private static Log log = ExoLogger.getLogger((String)"jcr.XmlResponseRepresentation");
    private WebDavNameSpaceContext nameSpaceContext;

    public XmlResponseRepresentation(WebDavNameSpaceContext nameSpaceContext) {
        this.nameSpaceContext = nameSpaceContext;
    }

    protected abstract void write(XMLStreamWriter var1) throws XMLStreamException, RepositoryException;

    public void writeObject(OutputStream outputStream) throws IOException {
        try {
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.setNamespaceContext(this.nameSpaceContext);
            this.write(writer);
            writer.writeEndDocument();
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled ecxeption. " + exc.getMessage()), (Throwable)exc);
        }
    }
}

