/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.representation.property;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.webdav.common.representation.property.WebDavPropertyRepresentation;

public class ChildCountRepresentation
extends WebDavPropertyRepresentation {
    public static final String TAGNAME = "childcount";
    private int childCount = 0;

    public void read(Node node) {
        try {
            if (!node.isNodeType("nt:file")) {
                NodeIterator nodeIter = node.getNodes();
                while (nodeIter.hasNext()) {
                    nodeIter.next();
                    ++this.childCount;
                }
            }
            this.status = 200;
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public String getTagName() {
        return TAGNAME;
    }

    protected void writeContent(XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (this.status != 200) {
            return;
        }
        xmlWriter.writeCharacters("" + this.childCount);
    }
}

