/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.representation.property;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.webdav.common.representation.property.WebDavPropertyRepresentation;

public class CreationDateRepresentation
extends WebDavPropertyRepresentation {
    public static final String TAGNAME = "creationdate";
    protected String creationDate = "";

    public void read(Node node) {
        try {
            if (node.isNodeType("nt:version")) {
                node = node.getNode("jcr:frozenNode");
            }
            Property createdProp = node.getProperty("jcr:created");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.creationDate = dateFormat.format(createdProp.getDate().getTime());
            this.status = 200;
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public String getTagName() {
        return TAGNAME;
    }

    protected void writeContent(XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeAttribute("b:dt", "dateTime.tz");
        xmlWriter.writeCharacters(this.creationDate);
    }
}

