/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.representation.property;

import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.common.representation.property.CommonWebDavProperty;
import org.w3c.dom.Node;

public class JcrPropertyRepresentation
extends CommonWebDavProperty {
    private static Log log = ExoLogger.getLogger((String)"jcr.JcrPropertyRepresentation");
    private String propertyNameSpace;
    private String propertyName;
    private String childNodeName;
    private String prefix;
    private String propertyValue = "";
    private String valueForUpdate;

    public JcrPropertyRepresentation(String propertyNameSpace, String propertyName) {
        this.propertyNameSpace = propertyNameSpace;
        this.propertyName = propertyName;
    }

    public JcrPropertyRepresentation(String propertyNameSpace, String propertyName, String childNodeName) {
        this.propertyNameSpace = propertyNameSpace;
        this.propertyName = propertyName;
        this.childNodeName = childNodeName;
    }

    public String getNameSpace() {
        return this.propertyNameSpace;
    }

    public String getTagName() {
        return this.propertyName;
    }

    protected void writeContent(XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeCharacters(this.propertyValue);
    }

    public void write(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.prefix = xmlWriter.getNamespaceContext().getPrefix(this.getNameSpace());
        if (this.prefix == null) {
            this.prefix = "";
        }
        if (this.status == 200) {
            if (this.prefix != null) {
                xmlWriter.writeStartElement(this.prefix, this.getTagName(), this.getNameSpace());
                xmlWriter.writeNamespace(this.prefix, this.getNameSpace());
            } else {
                xmlWriter.writeStartElement(this.getTagName(), this.getNameSpace());
            }
            this.writeContent(xmlWriter);
            xmlWriter.writeEndElement();
        } else {
            xmlWriter.writeEmptyElement(this.prefix, this.getTagName(), this.getNameSpace());
            xmlWriter.writeNamespace(this.prefix, this.getNameSpace());
        }
    }

    public void read(javax.jcr.Node node) {
        try {
            javax.jcr.Node nodeToSelect = node;
            if (this.childNodeName != null) {
                nodeToSelect = nodeToSelect.getNode(this.childNodeName);
            }
            SessionImpl session = (SessionImpl)nodeToSelect.getSession();
            this.prefix = session.getNamespacePrefix(this.propertyNameSpace);
            String prefixedName = this.prefix + ":" + this.propertyName;
            Property property = null;
            try {
                property = nodeToSelect.getProperty(prefixedName);
            }
            catch (PathNotFoundException pexc) {
                if (node.isNodeType("nt:file")) {
                    property = node.getNode("jcr:content").getProperty(prefixedName);
                }
                throw pexc;
            }
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                for (int i = 0; i < values.length; ++i) {
                    Value value = values[i];
                    if ("" != this.propertyValue) {
                        this.propertyValue = this.propertyValue + " ";
                    }
                    this.propertyValue = this.propertyValue + value.getString();
                }
            } else {
                this.propertyValue = property.getValue().getString();
            }
            this.status = 200;
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void update(javax.jcr.Node node) {
        try {
            if (this.childNodeName != null) {
                node = node.getNode(this.childNodeName);
            }
            SessionImpl session = (SessionImpl)node.getSession();
            this.prefix = session.getNamespacePrefix(this.propertyNameSpace);
            String prefixedName = this.prefix + ":" + this.propertyName;
            try {
                node.setProperty(prefixedName, this.valueForUpdate);
            }
            catch (ValueFormatException vexc) {
                String[] values = new String[]{this.valueForUpdate};
                node.setProperty(prefixedName, values);
            }
            node.getSession().save();
            this.status = 200;
        }
        catch (PathNotFoundException pexc) {
            this.status = 404;
        }
        catch (RepositoryException rexc) {
            this.status = 500;
        }
    }

    public void remove(javax.jcr.Node node) {
        try {
            if (this.childNodeName != null) {
                node = node.getNode(this.childNodeName);
            }
            SessionImpl session = (SessionImpl)node.getSession();
            this.prefix = session.getNamespacePrefix(this.propertyNameSpace);
            String prefixedName = this.prefix + ":" + this.propertyName;
            node.setProperty(prefixedName, (String)null);
            node.getSession().save();
            this.status = 200;
        }
        catch (RepositoryException rexc) {
            this.status = 500;
        }
    }

    public void parseContent(Node node) {
        this.valueForUpdate = node.getTextContent();
    }
}

