/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.representation.read;

import java.util.ArrayList;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.WebDavStatus;
import org.exoplatform.services.webdav.common.representation.property.JcrPropertyRepresentation;
import org.exoplatform.services.webdav.common.representation.property.PropertyRepresentation;
import org.exoplatform.services.webdav.common.representation.read.PropFindResponseRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllPropResponseRepresentation
extends PropFindResponseRepresentation {
    public AllPropResponseRepresentation(WebDavService webDavService, String href, Node node, int depth) throws RepositoryException {
        super(webDavService, href, node, depth);
    }

    @Override
    protected void writeResponseContent(XMLStreamWriter xmlStreamWriter, Node node) throws XMLStreamException, RepositoryException {
        ArrayList<PropertyRepresentation> properties = this.getProperties(node);
        xmlStreamWriter.writeStartElement("DAV:", "propstat");
        xmlStreamWriter.writeStartElement("DAV:", "prop");
        for (int i = 0; i < properties.size(); ++i) {
            PropertyRepresentation property = properties.get(i);
            property.read(node);
            if (property.getStatus() != 200) continue;
            property.write(xmlStreamWriter);
        }
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeStartElement("DAV:", "status");
        xmlStreamWriter.writeCharacters(WebDavStatus.getStatusDescription(200));
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeEndElement();
    }

    protected ArrayList<PropertyRepresentation> getProperties(Node node) throws RepositoryException {
        SessionImpl session = (SessionImpl)node.getSession();
        ArrayList<PropertyRepresentation> properties = new ArrayList<PropertyRepresentation>();
        HashMap<String, HashMap<String, String>> allProperties = this.webDavService.getProperies();
        HashMap<String, String> allWebDavProperties = allProperties.get("DAV:");
        for (String propertyName : allWebDavProperties.keySet()) {
            properties.add(this.webDavService.getPropertyRepresentation("DAV:", propertyName, this.href));
        }
        ArrayList<String> presentedProperties = new ArrayList<String>();
        PropertyIterator propIter = node.getProperties();
        while (propIter.hasNext()) {
            Property property = propIter.nextProperty();
            String propertyName = property.getName();
            if ("jcr:data".equals(propertyName) || presentedProperties.contains(propertyName) || propertyName.indexOf(":") < 0) continue;
            presentedProperties.add(propertyName);
            String prefixOnly = propertyName.split(":")[0];
            String nameSpace = session.getNamespaceURI(prefixOnly);
            String nameOnly = propertyName.split(":")[1];
            properties.add(new JcrPropertyRepresentation(nameSpace, nameOnly));
        }
        if (node.isNodeType("nt:file")) {
            Node jcrContentNode = node.getNode("jcr:content");
            propIter = jcrContentNode.getProperties();
            while (propIter.hasNext()) {
                Property property = propIter.nextProperty();
                String propertyName = property.getName();
                if ("jcr:data".equals(propertyName) || presentedProperties.contains(propertyName) || propertyName.indexOf(":") < 0) continue;
                presentedProperties.add(propertyName);
                String prefixOnly = propertyName.split(":")[0];
                String nameSpace = session.getNamespaceURI(prefixOnly);
                String nameOnly = propertyName.split(":")[1];
                properties.add(new JcrPropertyRepresentation(nameSpace, nameOnly, "jcr:content"));
            }
        }
        return properties;
    }
}

