/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.representation.read;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.WebDavStatus;
import org.exoplatform.services.webdav.common.representation.property.PropertyRepresentation;
import org.exoplatform.services.webdav.common.representation.read.AllPropResponseRepresentation;

public class PropNamesResponseRepresentation
extends AllPropResponseRepresentation {
    public PropNamesResponseRepresentation(WebDavService webDavService, String href, Node node, int depth) throws RepositoryException {
        super(webDavService, href, node, depth);
    }

    protected void writeResponseContent(XMLStreamWriter xmlStreamWriter, Node node) throws XMLStreamException, RepositoryException {
        ArrayList<PropertyRepresentation> properties = this.getProperties(node);
        xmlStreamWriter.writeStartElement("DAV:", "propstat");
        xmlStreamWriter.writeStartElement("DAV:", "prop");
        for (int i = 0; i < properties.size(); ++i) {
            PropertyRepresentation property = properties.get(i);
            property.read(node);
            if (property.getStatus() != 200) continue;
            property.setStatus(404);
            property.write(xmlStreamWriter);
        }
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeStartElement("DAV:", "status");
        xmlStreamWriter.writeCharacters(WebDavStatus.getStatusDescription(200));
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeEndElement();
    }
}

