/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.representation.write;

import java.util.ArrayList;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.common.representation.property.PropertyRepresentation;
import org.exoplatform.services.webdav.common.representation.write.PropertyUpdateResponseRepresentation;
import org.exoplatform.services.webdav.common.util.DavUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUpdateRepresentationFactory {
    public static final String XML_PROPERTYUPDATE = "propertyupdate";
    public static final String XML_SET = "set";
    public static final String XML_REMOVE = "remove";

    public static PropertyUpdateResponseRepresentation createResponseRepresentation(WebDavService webDavService, Document document, Item node, String href) throws RepositoryException {
        Node propertyUpdate = DavUtil.getChildNode(document, XML_PROPERTYUPDATE);
        ArrayList<PropertyRepresentation> setList = PropertyUpdateRepresentationFactory.parseSetList(webDavService, DavUtil.getChildNode(propertyUpdate, XML_SET), href + node.getPath());
        ArrayList<PropertyRepresentation> removeList = PropertyUpdateRepresentationFactory.parseRemoveList(webDavService, DavUtil.getChildNode(propertyUpdate, XML_REMOVE), href + node.getPath());
        return new PropertyUpdateResponseRepresentation(node, href, setList, removeList);
    }

    protected static ArrayList<PropertyRepresentation> parseSetList(WebDavService webDavService, Node setNode, String href) {
        ArrayList<PropertyRepresentation> setList = new ArrayList<PropertyRepresentation>();
        if (setNode != null) {
            Node nodeProp = DavUtil.getChildNode(setNode, "prop");
            NodeList nodes = nodeProp.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node propertyNode = nodes.item(i);
                String nameSpace = propertyNode.getNamespaceURI();
                String localName = propertyNode.getLocalName();
                if (nameSpace == null || localName == null) continue;
                PropertyRepresentation propertyRepresentation = webDavService.getPropertyRepresentation(nameSpace, localName, href);
                propertyRepresentation.parseContent(propertyNode);
                setList.add(propertyRepresentation);
            }
        }
        return setList;
    }

    protected static ArrayList<PropertyRepresentation> parseRemoveList(WebDavService webDavService, Node removeNode, String href) {
        ArrayList<PropertyRepresentation> removeList = new ArrayList<PropertyRepresentation>();
        if (removeNode != null) {
            Node nodeProp = DavUtil.getChildNode(removeNode, "prop");
            NodeList nodes = nodeProp.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node propertyNode = nodes.item(i);
                String nameSpace = propertyNode.getNamespaceURI();
                String localName = propertyNode.getLocalName();
                if (nameSpace == null || localName == null) continue;
                PropertyRepresentation propertyRepresentation = webDavService.getPropertyRepresentation(nameSpace, localName, href);
                removeList.add(propertyRepresentation);
            }
        }
        return removeList;
    }
}

