/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.resource.resourcedata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Calendar;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.common.resource.resourcedata.AbstractResourceData;

public class JcrPropertyData
extends AbstractResourceData {
    private static Log log = ExoLogger.getLogger((String)"jcr.JcrPropertyData");

    public JcrPropertyData(Property property) throws RepositoryException, IOException {
        this.name = property.getName();
        this.iscollection = false;
        this.lastModified = Calendar.getInstance().getTime().toString();
        this.contentType = "application/octet-stream";
        if (property.getDefinition().isMultiple()) {
            this.fillMultipleData(property);
        } else {
            this.fillSingleData(property);
        }
    }

    protected void fillSingleData(Property property) throws RepositoryException, IOException {
        if (this.isStringValue(property.getValue())) {
            this.resourceInputStream = new ByteArrayInputStream(property.getValue().getString().getBytes());
            this.resourceLenght = this.resourceInputStream.available();
        } else {
            this.resourceLenght = property.getLength();
            this.resourceInputStream = property.getValue().getStream();
        }
    }

    protected void fillMultipleData(Property property) throws RepositoryException, IOException {
        Value[] values = property.getValues();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        for (int i = 0; i < values.length; ++i) {
            Value propertyValue = values[i];
            if (this.isStringValue(propertyValue)) {
                outStream.write(propertyValue.getString().getBytes());
                if (i == values.length - 1) continue;
                outStream.write("\r\n".getBytes());
                continue;
            }
            log.info((Object)("TYPE: " + propertyValue.getType()));
        }
        this.resourceInputStream = new ByteArrayInputStream(outStream.toByteArray());
        this.resourceLenght = this.resourceInputStream.available();
    }

    protected boolean isStringValue(Value value) {
        return value.getType() == 1 || value.getType() == 7;
    }
}

