/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.resource.resourcedata;

import java.io.ByteArrayInputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.common.resource.resourcedata.AbstractResourceData;
import org.exoplatform.services.webdav.common.util.DavUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlItemData
extends AbstractResourceData {
    public static final String PREFIX = "sv:";
    public static final String PREFIX_XMLNS = "xmlns:sv";
    public static final String PREFIX_LINK = "http://www.jcp.org/jcr/sv/1.0";
    public static final String XLINK_XMLNS = "xmlns:xlink";
    public static final String XLINK_LINK = "http://www.w3.org/1999/xlink";
    public static final String XML_NODE = "sv:node";
    public static final String XML_NAME = "sv:name";
    public static final String XML_PROPERTY = "sv:property";
    public static final String XML_HREF = "xlink:href";

    public XmlItemData(String rootPrefix, Node rootItem) throws Exception {
        this.iscollection = true;
        this.name = rootItem.getName();
        this.contentType = "text/html";
        this.lastModified = "" + Calendar.getInstance();
        int depth = 1;
        Document document = DavUtil.getDomDocument();
        Element nodeElement = this.searchData(rootPrefix, rootItem, document, depth);
        document.appendChild(nodeElement);
        byte[] xmlBytes = DavUtil.getSerializedDom(nodeElement);
        this.resourceInputStream = new ByteArrayInputStream(xmlBytes);
        this.resourceLenght = this.resourceInputStream.available();
    }

    protected Element searchData(String rootHref, Node node, Document document, int depth) throws RepositoryException {
        Element nodeElement = document.createElement(XML_NODE);
        nodeElement.setAttribute(PREFIX_XMLNS, PREFIX_LINK);
        nodeElement.setAttribute(XLINK_XMLNS, XLINK_LINK);
        String itemName = node.getName();
        nodeElement.setAttribute(XML_NAME, itemName);
        String itemPath = node.getPath();
        nodeElement.setAttribute(XML_HREF, rootHref + itemPath);
        PropertyIterator propIter = node.getProperties();
        while (propIter.hasNext()) {
            Property curProperty = propIter.nextProperty();
            Element propertyElement = document.createElement(XML_PROPERTY);
            propertyElement.setAttribute(XML_NAME, curProperty.getName());
            String propertyHref = rootHref + curProperty.getPath();
            propertyElement.setAttribute(XML_HREF, propertyHref);
            nodeElement.appendChild(propertyElement);
        }
        NodeIterator nodeIter = node.getNodes();
        while (nodeIter.hasNext()) {
            Node childNode = nodeIter.nextNode();
            Element childNodeElement = document.createElement(XML_NODE);
            childNodeElement.setAttribute(XML_NAME, childNode.getName());
            String childNodeHref = rootHref + childNode.getPath();
            childNodeElement.setAttribute(XML_HREF, childNodeHref);
            nodeElement.appendChild(childNodeElement);
        }
        return nodeElement;
    }
}

