/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.deltav.command;

import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.HeaderParam;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.ResourceDispatcher;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.transformer.SerializableTransformer;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.WebDavXmlInputTransformer;
import org.exoplatform.services.webdav.common.command.WebDavCommand;
import org.exoplatform.services.webdav.common.resource.JCRResourceDispatcher;
import org.w3c.dom.Document;

@URITemplate(value="/jcr/")
public class LabelCommand
extends WebDavCommand {
    public LabelCommand(WebDavService webDavService, ResourceDispatcher resourceDispatcher, ThreadLocalSessionProviderService sessionProviderService) {
        super(webDavService, resourceDispatcher, sessionProviderService);
    }

    @HTTPMethod(value="LABEL")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=WebDavXmlInputTransformer.class)
    @OutputTransformer(value=SerializableTransformer.class)
    public Response label(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="Authorization") String authorization, Document document, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @QueryParam(value="VERSIONID") String versionId) {
        try {
            SessionProvider sessionProvider = this.getSessionProvider(authorization);
            Item item = new JCRResourceDispatcher(sessionProvider, this.webDavService.getRepository(repoName)).getItem(repoPath);
            if (!(item instanceof Node)) {
                throw new AccessDeniedException();
            }
            ArrayList<String> lockTokens = this.getLockTokens(lockTokenHeader, ifHeader);
            this.tuneSession(item.getSession(), lockTokens);
            Node node = (Node)item;
            return null;
        }
        catch (Exception exc) {
            return this.responseByException(exc);
        }
    }
}

