/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.deltav.representation.property;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.webdav.common.representation.HrefRepresentation;
import org.exoplatform.services.webdav.common.representation.property.WebDavPropertyRepresentation;

public class PredecessorSetRepresentation
extends WebDavPropertyRepresentation {
    public static final String TAGNAME = "predecessor-set";
    private String href;
    private ArrayList<String> predecessorHrefs = new ArrayList();

    public PredecessorSetRepresentation(String href) {
        this.href = href;
    }

    public void read(Node node) {
        if (!(node instanceof Version)) {
            return;
        }
        try {
            Version[] predecessors = ((Version)node).getPredecessors();
            while (predecessors.length > 0 && !"jcr:rootVersion".equals(predecessors[0].getName())) {
                this.predecessorHrefs.add(this.href + "?VERSIONID=" + predecessors[0].getName());
                predecessors = predecessors[0].getPredecessors();
            }
            this.status = 200;
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public String getTagName() {
        return TAGNAME;
    }

    protected void writeContent(XMLStreamWriter xmlWriter) throws XMLStreamException {
        for (int i = 0; i < this.predecessorHrefs.size(); ++i) {
            String predecessorHref = this.predecessorHrefs.get(i);
            new HrefRepresentation(predecessorHref).write(xmlWriter);
        }
    }
}

