/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.deltav.representation.property;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.webdav.common.representation.HrefRepresentation;
import org.exoplatform.services.webdav.common.representation.property.WebDavPropertyRepresentation;

public class SuccessorSetRepresentation
extends WebDavPropertyRepresentation {
    public static final String TAGNAME = "successor-set";
    private String href;
    private ArrayList<String> successorHrefs = new ArrayList();

    public SuccessorSetRepresentation(String href) {
        this.href = href;
    }

    public void read(Node node) {
        if (!(node instanceof Version)) {
            return;
        }
        try {
            Version[] successors = ((Version)node).getSuccessors();
            while (successors.length > 0) {
                this.successorHrefs.add(this.href + "?VERSIONID=" + successors[0].getName());
                successors = successors[0].getSuccessors();
            }
            this.status = 200;
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public String getTagName() {
        return TAGNAME;
    }

    protected void writeContent(XMLStreamWriter xmlWriter) throws XMLStreamException {
        for (int i = 0; i < this.successorHrefs.size(); ++i) {
            String successorHref = this.successorHrefs.get(i);
            new HrefRepresentation(successorHref).write(xmlWriter);
        }
    }
}

