/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.lnkproducer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.ResourceDispatcher;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.PassthroughInputTransformer;
import org.exoplatform.services.rest.transformer.PassthroughOutputTransformer;
import org.exoplatform.services.webdav.lnkproducer.LinkGenerator;

@URITemplate(value="/lnkproducer/")
public class LnkProducer
implements ResourceContainer {
    private ResourceDispatcher resourceDispatcher;

    public LnkProducer(ResourceDispatcher resourceDispatcher) {
        this.resourceDispatcher = resourceDispatcher;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/{linkFilePath}/")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response produceLink(@URIParam(value="linkFilePath") String linkFilePath, @QueryParam(value="path") String path) {
        String contextHref = this.resourceDispatcher.getRuntimeContext().getContextHref();
        contextHref = contextHref + "/jcr";
        ResourceDispatcher.Context context = this.resourceDispatcher.getRuntimeContext();
        String hostName = context.getServerName();
        try {
            LinkGenerator linkGenerator = new LinkGenerator(hostName, contextHref, path);
            byte[] content = linkGenerator.generateLinkContent();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content);
            return Response.Builder.ok().header("Content-Length", "" + content.length).entity((Object)byteArrayInputStream, "application/octet-stream").build();
        }
        catch (IOException ioexc) {
            return Response.Builder.serverError().build();
        }
    }
}

