/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.order.representation;

import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.webdav.WebDavStatus;
import org.exoplatform.services.webdav.common.representation.HrefRepresentation;
import org.exoplatform.services.webdav.common.representation.WebDavNameSpaceContext;
import org.exoplatform.services.webdav.common.representation.XmlResponseRepresentation;
import org.exoplatform.services.webdav.order.OrderMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderPatchResponseRepresentation
extends XmlResponseRepresentation {
    public static final String XML_MULTISTATUS = "multistatus";
    public static final String XML_RESPONSE = "response";
    private ArrayList<OrderMember> orderMembers = new ArrayList();
    private String href;
    private Node node;
    private ArrayList<OrderMember> orderResult = new ArrayList();

    public OrderPatchResponseRepresentation(String href, Node node, ArrayList<OrderMember> orderMembers) throws RepositoryException {
        super(new WebDavNameSpaceContext((ManageableRepository)node.getSession().getRepository()));
        this.href = href;
        this.node = node;
        this.orderMembers = orderMembers;
    }

    public int doOrder() {
        for (int i = 0; i < this.orderMembers.size(); ++i) {
            OrderMember orderMember = this.orderMembers.get(i);
            int orderStatus = 200;
            try {
                this.node.getSession().refresh(false);
                this.doOrderNode(this.node, orderMember);
            }
            catch (PathNotFoundException pexc) {
                orderStatus = 404;
            }
            catch (AccessDeniedException aexc) {
                orderStatus = 403;
            }
            catch (RepositoryException rexc) {
                orderStatus = 409;
            }
            if (orderStatus == 200) continue;
            orderMember.setStatus(orderStatus);
            this.orderResult.add(orderMember);
        }
        if (this.orderResult.size() == 0) {
            return 200;
        }
        return 207;
    }

    private void doOrderNode(Node parentNode, OrderMember member) throws RepositoryException {
        String positionedNodeName = null;
        if (!parentNode.hasNode(member.getSegment())) {
            throw new PathNotFoundException();
        }
        if (1 != member.getPosition()) {
            NodeIterator nodes = parentNode.getNodes();
            boolean finded = false;
            while (nodes.hasNext()) {
                Node curNode = nodes.nextNode();
                if (0 == member.getPosition()) {
                    positionedNodeName = curNode.getName();
                    finded = true;
                    break;
                }
                if (2 == member.getPosition() && curNode.getName().equals(member.getPositionSegment())) {
                    positionedNodeName = curNode.getName();
                    finded = true;
                    break;
                }
                if (3 != member.getPosition() || !curNode.getName().equals(member.getPositionSegment())) continue;
                if (nodes.hasNext()) {
                    Node nextNode = nodes.nextNode();
                    positionedNodeName = nextNode.getName();
                    finded = true;
                    break;
                }
                finded = true;
                break;
            }
            if (!finded) {
                throw new AccessDeniedException();
            }
        }
        parentNode.orderBefore(member.getSegment(), positionedNodeName);
        parentNode.getSession().save();
        parentNode.getSession().refresh(false);
    }

    @Override
    protected void write(XMLStreamWriter writer) throws XMLStreamException, RepositoryException {
        writer.writeStartElement("D", XML_MULTISTATUS, "DAV:");
        writer.writeNamespace("D", "DAV:");
        for (int i = 0; i < this.orderResult.size(); ++i) {
            OrderMember orderMember = this.orderResult.get(i);
            writer.writeStartElement("DAV:", XML_RESPONSE);
            String curHref = this.href + "/" + orderMember.getSegment();
            new HrefRepresentation(curHref).write(writer);
            writer.writeStartElement("DAV:", "status");
            writer.writeCharacters(WebDavStatus.getStatusDescription(orderMember.getStatus()));
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

