/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.search.representation;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.common.representation.HrefRepresentation;
import org.exoplatform.services.webdav.common.representation.read.AllPropResponseRepresentation;

public class QuerySearchResultRepresentation
extends AllPropResponseRepresentation {
    private QueryResult queryResult;

    public QuerySearchResultRepresentation(WebDavService webDavService, String href, Node node, String sqlQuery, String queryLanguage) throws RepositoryException {
        super(webDavService, href, node, 0);
        QueryManager queryManager = node.getSession().getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(sqlQuery, queryLanguage);
        this.queryResult = query.execute();
    }

    protected void listRecursive(XMLStreamWriter xmlStreamWriter, Node curNode, int curDepth) throws XMLStreamException, RepositoryException {
        NodeIterator nodeIter = this.queryResult.getNodes();
        while (nodeIter.hasNext()) {
            Node nextNode = nodeIter.nextNode();
            if (nextNode.isNodeType("nt:resource")) {
                if (!nextNode.getParent().isNodeType("nt:file")) continue;
                nextNode = nextNode.getParent();
            }
            xmlStreamWriter.writeStartElement("D", "response", "DAV:");
            new HrefRepresentation(this.defaultHref + nextNode.getPath()).write(xmlStreamWriter);
            this.writeResponseContent(xmlStreamWriter, nextNode);
            xmlStreamWriter.writeEndElement();
        }
    }
}

