/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.search.representation;

import javax.jcr.Item;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.common.BadRequestException;
import org.exoplatform.services.webdav.common.representation.XmlResponseRepresentation;
import org.exoplatform.services.webdav.common.util.DavUtil;
import org.exoplatform.services.webdav.search.representation.QuerySearchResultRepresentation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SearchResultRepresentationFactory {
    public static final String XML_SEARCHREQUEST = "searchrequest";

    public static XmlResponseRepresentation createSearchResultRepresentation(WebDavService webDavService, Document document, Item node, String href) throws RepositoryException, BadRequestException {
        Node searchRequest = DavUtil.getChildNode(document, XML_SEARCHREQUEST);
        Node sqlNode = DavUtil.getChildNode(searchRequest, "sql");
        if (sqlNode != null) {
            String query = sqlNode.getTextContent();
            return new QuerySearchResultRepresentation(webDavService, href, (javax.jcr.Node)node, query, "sql");
        }
        Node xPathNode = DavUtil.getChildNode(searchRequest, "xpath");
        if (xPathNode != null) {
            String query = xPathNode.getTextContent();
            return new QuerySearchResultRepresentation(webDavService, href, (javax.jcr.Node)node, query, "xpath");
        }
        throw new BadRequestException();
    }
}

