/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.lnkproducer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LinkGenerator {
    public static int[] linkHeader = new int[]{76, 0, 0, 0, 1, 20, 2, 0, 0, 0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 70, 129, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private String hostName;
    private String servletPath;
    private String targetPath;

    public LinkGenerator(String hostName, String servletPath, String targetPath) {
        this.hostName = hostName;
        this.servletPath = servletPath;
        this.targetPath = targetPath;
    }

    public byte[] generateLinkContent() throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        for (int i = 0; i < linkHeader.length; ++i) {
            byte curByteValue = (byte)linkHeader[i];
            outStream.write(curByteValue);
        }
        byte[] linkContent = this.getLinkContent();
        this.writeInt(linkContent.length + 2, outStream);
        outStream.write(linkContent);
        for (int i = 0; i < 6; ++i) {
            outStream.write(0);
        }
        return outStream.toByteArray();
    }

    private byte[] getLinkContent() throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] firstItem = this.getFirstItem();
        this.writeInt(firstItem.length + 2, outStream);
        this.writeBytes(firstItem, outStream);
        byte[] lastItem = this.getLastItem();
        this.writeInt(lastItem.length + 2, outStream);
        this.writeBytes(lastItem, outStream);
        String[] pathes = this.servletPath.split("/");
        String root = pathes[pathes.length - 1];
        byte[] rootItem = this.getRootItem(root, this.servletPath);
        this.writeInt(rootItem.length + 2, outStream);
        this.writeBytes(rootItem, outStream);
        pathes = this.targetPath.split("/");
        String curHref = this.servletPath;
        for (int i = 0; i < pathes.length; ++i) {
            if ("".equals(pathes[i])) continue;
            String curName = pathes[i];
            curHref = curHref + "/" + curName;
            if (i < pathes.length - 1) {
                byte[] linkItem = this.getHreffedFolder(curName, curHref);
                this.writeInt(linkItem.length + 2, outStream);
                this.writeBytes(linkItem, outStream);
                continue;
            }
            byte[] linkFile = this.getHreffedFile(curName, curHref);
            this.writeInt(linkFile.length + 2, outStream);
            this.writeBytes(linkFile, outStream);
        }
        return outStream.toByteArray();
    }

    private byte[] getFirstItem() throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        int[] firstItem = new int[]{31, 80, 224, 79, 208, 32, 234, 58, 105, 16, 162, 216, 8, 0, 43, 48, 48, 157};
        this.writeInts(firstItem, outStream);
        return outStream.toByteArray();
    }

    private byte[] getLastItem() throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        int[] lastItem = new int[]{46, 128, 0, 223, 234, 189, 101, 194, 208, 17, 188, 237, 0, 160, 201, 10, 181, 15};
        this.writeInts(lastItem, outStream);
        return outStream.toByteArray();
    }

    private byte[] getRootItem(String rootName, String servlet) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] rootHead = this.getRootHeader();
        this.writeBytes(rootHead, outStream);
        byte[] rootValue = this.getRootValue(rootName);
        this.writeInt(rootValue.length / 2, outStream);
        this.writeBytes(rootValue, outStream);
        outStream.write(0);
        outStream.write(0);
        this.writeSizedString(servlet, outStream);
        this.writeZeroQWord(outStream);
        return outStream.toByteArray();
    }

    private byte[] getRootHeader() throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        int[] rootHeader = new int[]{76, 80, 0, 1, 66, 87, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0};
        this.writeInts(rootHeader, outStream);
        return outStream.toByteArray();
    }

    private byte[] getRootValue(String rootName) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.simpleWriteString(rootName, outStream);
        int[] rootVal = new int[]{32, 0, 61, 4, 48, 4, 32, 0};
        this.writeInts(rootVal, outStream);
        this.simpleWriteString(this.hostName, outStream);
        return outStream.toByteArray();
    }

    private byte[] getHreffedFolder(String itemName, String itemHref) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        int[] linkHrefHeader = new int[]{76, 80, 0, 34, 66, 87, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 64};
        this.writeInts(linkHrefHeader, outStream);
        this.writeSizedString(itemName, outStream);
        this.writeSizedString(itemHref, outStream);
        this.writeZeroQWord(outStream);
        return outStream.toByteArray();
    }

    private byte[] getHreffedFile(String itemName, String itemHref) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        int[] attrs = new int[]{76, 80, 0, 34, 66, 87, 240, 67, 28, 41, 182, 92, 199, 1, 0, 124, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0};
        this.writeInts(attrs, outStream);
        this.writeSizedString(itemName, outStream);
        this.writeSizedString(itemHref, outStream);
        this.writeZeroQWord(outStream);
        return outStream.toByteArray();
    }

    private void simpleWriteString(String outString, OutputStream outStream) throws IOException {
        for (int i = 0; i < outString.length(); ++i) {
            int charCode = outString.codePointAt(i);
            outStream.write(charCode & 0xFF);
            outStream.write(charCode >> 8 & 0xFF);
        }
    }

    private void writeZeroString(String outString, OutputStream outStream) throws IOException {
        this.simpleWriteString(outString, outStream);
        outStream.write(0);
        outStream.write(0);
    }

    private void writeSizedString(String outString, OutputStream outStream) throws IOException {
        int stringLength = outString.length();
        this.writeInt(stringLength, outStream);
        this.writeZeroString(outString, outStream);
    }

    private void writeInt(int intValue, OutputStream outStream) throws IOException {
        int lowByte = intValue & 0xFF;
        int highByte = (intValue & 0xFF00) >> 8;
        outStream.write((byte)lowByte);
        outStream.write((byte)highByte);
    }

    private void writeInts(int[] bytes, OutputStream outStream) throws IOException {
        for (int i = 0; i < bytes.length; ++i) {
            byte curByte = (byte)bytes[i];
            outStream.write(curByte);
        }
    }

    private void writeBytes(byte[] bytes, OutputStream outStream) throws IOException {
        for (int i = 0; i < bytes.length; ++i) {
            byte curByte = bytes[i];
            outStream.write(curByte);
        }
    }

    private void writeZeroQWord(OutputStream outStream) throws IOException {
        int[] zeroQWord = new int[]{0, 0, 0, 0};
        this.writeInts(zeroQWord, outStream);
    }
}

