/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.net.URI;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.webdav.resource.FileResource;
import org.exoplatform.services.jcr.webdav.resource.ResourceUtil;
import org.exoplatform.services.jcr.webdav.util.PropertyConstants;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.rest.Response;

public class HeadCommand {
    public Response head(Session session, String path, String baseURI) {
        try {
            Node node = (Node)session.getItem(path);
            WebDavNamespaceContext nsContext = new WebDavNamespaceContext(session);
            URI uri = new URI(TextUtil.escape(baseURI + node.getPath(), '%', true));
            if (ResourceUtil.isFile(node)) {
                FileResource resource = new FileResource(uri, node, nsContext);
                String lastModified = resource.getProperty(PropertyConstants.GETLASTMODIFIED).getValue();
                String contentType = resource.getProperty(PropertyConstants.GETCONTENTTYPE).getValue();
                String contentLength = resource.getProperty(PropertyConstants.GETCONTENTLENGTH).getValue();
                return Response.Builder.ok().header("Last-Modified", lastModified).header("Content-type", contentType).header("Content-Length", contentLength).build();
            }
            return Response.Builder.ok().build();
        }
        catch (PathNotFoundException exc) {
            return Response.Builder.notFound().build();
        }
        catch (Exception exc) {
            return Response.Builder.serverError().build();
        }
    }
}

