/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.resource;

import java.io.InputStream;
import java.net.URI;
import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.xml.namespace.QName;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.resource.GenericResource;
import org.exoplatform.services.jcr.webdav.resource.VersionedResource;
import org.exoplatform.services.jcr.webdav.util.DeltaVConstants;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;

public class VersionResource
extends GenericResource {
    protected final Version version;
    protected final VersionedResource versionedResource;

    public VersionResource(URI identifier, VersionedResource versionedResource, Version version, WebDavNamespaceContext namespaceContext) {
        super(4, identifier, namespaceContext);
        this.version = version;
        this.versionedResource = versionedResource;
    }

    public HierarchicalProperty getProperty(QName name) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        if (DeltaVConstants.VERSIONNAME.equals(name)) {
            return new HierarchicalProperty(name, this.version.getName());
        }
        if (DeltaVConstants.DISPLAYNAME.equals(name)) {
            return new HierarchicalProperty(name, this.version.getName());
        }
        if (DeltaVConstants.VERSIONHISTORY.equals(name)) {
            return new HierarchicalProperty(name);
        }
        if (DeltaVConstants.CHECKEDIN.equals(name)) {
            HierarchicalProperty checkedInProperty = new HierarchicalProperty(name);
            HierarchicalProperty href = checkedInProperty.addChild(new HierarchicalProperty(new QName("DAV:", "href")));
            href.setValue(this.identifier.toASCIIString());
            return checkedInProperty;
        }
        if (DeltaVConstants.PREDECESSORSET.equals(name)) {
            Version[] predecessors = this.version.getPredecessors();
            HierarchicalProperty predecessorsProperty = new HierarchicalProperty(name);
            for (Version curVersion : predecessors) {
                if ("jcr:rootVersion".equals(curVersion.getName())) continue;
                String versionHref = this.versionedResource.getIdentifier().toASCIIString() + "/?version=" + curVersion.getName();
                HierarchicalProperty href = predecessorsProperty.addChild(new HierarchicalProperty(new QName("DAV:", "href")));
                href.setValue(versionHref);
            }
            return predecessorsProperty;
        }
        if (DeltaVConstants.SUCCESSORSET.equals(name)) {
            Version[] successors = this.version.getSuccessors();
            HierarchicalProperty successorsProperty = new HierarchicalProperty(name);
            for (Version curVersion : successors) {
                String versionHref = this.versionedResource.getIdentifier().toASCIIString() + "/?version=" + curVersion.getName();
                HierarchicalProperty href = successorsProperty.addChild(new HierarchicalProperty(new QName("DAV:", "href")));
                href.setValue(versionHref);
            }
            return successorsProperty;
        }
        if (DeltaVConstants.RESOURCETYPE.equals(name)) {
            HierarchicalProperty resourceType = new HierarchicalProperty(name);
            if (this.versionedResource.isCollection()) {
                resourceType.addChild(new HierarchicalProperty("DAV:", "collection"));
            }
            return resourceType;
        }
        if (DeltaVConstants.GETCONTENTLENGTH.equals(name)) {
            if (this.versionedResource.isCollection()) {
                throw new PathNotFoundException();
            }
            HierarchicalProperty getContentLength = new HierarchicalProperty(name);
            Property jcrDataProperty = this.contentNode().getProperty("jcr:data");
            getContentLength.setValue("" + jcrDataProperty.getLength());
            return getContentLength;
        }
        if (DeltaVConstants.GETCONTENTTYPE.equals(name)) {
            if (this.versionedResource.isCollection()) {
                throw new PathNotFoundException();
            }
            HierarchicalProperty getContentType = new HierarchicalProperty(name);
            Property mimeType = this.contentNode().getProperty("jcr:mimeType");
            getContentType.setValue(mimeType.getString());
            return getContentType;
        }
        if (DeltaVConstants.CREATIONDATE.equals(name)) {
            Calendar created = this.version.getNode("jcr:frozenNode").getProperty("jcr:created").getDate();
            HierarchicalProperty creationDate = new HierarchicalProperty(name, created, "yyyy-MM-dd'T'HH:mm:ss'Z'");
            creationDate.setAttribute("b:dt", "dateTime.tz");
            return creationDate;
        }
        throw new PathNotFoundException();
    }

    public final boolean isCollection() {
        return false;
    }

    public Node contentNode() throws RepositoryException {
        return this.version.getNode("jcr:frozenNode").getNode("jcr:content");
    }

    public InputStream getContentAsStream() throws RepositoryException {
        return this.contentNode().getProperty("jcr:data").getStream();
    }
}

