/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav;

import javax.ws.rs.core.MediaType;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.services.jcr.webdav.util.TextUtil;

public class MimeTypeRecognizer {
    private final MimeTypeResolver mimeTypeResolver;
    private final MediaType mediaType;
    private final boolean untrustedAgent;
    private final String fileName;

    public MimeTypeRecognizer(String fileName, MimeTypeResolver mimeTypeResolver, MediaType mediaType, boolean untrustedAgent) {
        this.mimeTypeResolver = mimeTypeResolver;
        this.mediaType = mediaType;
        this.untrustedAgent = untrustedAgent;
        this.fileName = fileName;
    }

    public boolean isMimeTypeRecognized() {
        return !TextUtil.getExtension(this.fileName).isEmpty();
    }

    public boolean isEncodingSet() {
        return !this.untrustedAgent && this.mediaType != null && this.mediaType.getParameters().get("charset") != null;
    }

    public String getMimeType() {
        if (this.mediaType == null || this.untrustedAgent) {
            return this.mimeTypeResolver.getMimeType(this.fileName);
        }
        return this.mediaType.getType() + "/" + this.mediaType.getSubtype();
    }

    public String getEncoding() {
        if (this.mediaType == null || this.untrustedAgent) {
            return null;
        }
        return (String)this.mediaType.getParameters().get("charset");
    }
}

