/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.resource;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.exoplatform.commons.utils.Tools;

public class HierarchicalProperty {
    protected List<HierarchicalProperty> children;
    protected QName name;
    protected String value;
    protected HashMap<String, String> attributes = new HashMap();

    public HierarchicalProperty(String name, String value) {
        String[] tmp = name.split(":");
        this.name = tmp.length > 1 ? new QName(tmp[0], tmp[1]) : new QName(tmp[0]);
        this.value = value;
        this.children = new ArrayList<HierarchicalProperty>();
    }

    public HierarchicalProperty(QName name, String value) {
        this.name = name;
        this.value = value;
        this.children = new ArrayList<HierarchicalProperty>();
    }

    public HierarchicalProperty(QName name, Calendar dateValue, String formatPattern) {
        this(name, null);
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatPattern, Locale.ENGLISH);
        dateFormat.setTimeZone(Tools.getTimeZone((String)"GMT"));
        this.value = dateFormat.format(dateValue.getTime());
    }

    public HierarchicalProperty(QName name) {
        this(name, null);
    }

    public HierarchicalProperty addChild(HierarchicalProperty prop) {
        this.children.add(prop);
        return prop;
    }

    public List<HierarchicalProperty> getChildren() {
        return this.children;
    }

    public HierarchicalProperty getChild(QName name) {
        for (HierarchicalProperty child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public HierarchicalProperty getChild(int index) {
        return this.children.get(index);
    }

    public QName getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setAttribute(String attributeName, String attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public String getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }
}

