/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.webdav.Depth;
import org.exoplatform.services.jcr.webdav.MimeTypeRecognizer;
import org.exoplatform.services.jcr.webdav.PreconditionException;
import org.exoplatform.services.jcr.webdav.Range;
import org.exoplatform.services.jcr.webdav.WebDavService;
import org.exoplatform.services.jcr.webdav.WebDavServiceInitParams;
import org.exoplatform.services.jcr.webdav.command.AclCommand;
import org.exoplatform.services.jcr.webdav.command.CopyCommand;
import org.exoplatform.services.jcr.webdav.command.DeleteCommand;
import org.exoplatform.services.jcr.webdav.command.GetCommand;
import org.exoplatform.services.jcr.webdav.command.HeadCommand;
import org.exoplatform.services.jcr.webdav.command.LockCommand;
import org.exoplatform.services.jcr.webdav.command.MkColCommand;
import org.exoplatform.services.jcr.webdav.command.MoveCommand;
import org.exoplatform.services.jcr.webdav.command.OrderPatchCommand;
import org.exoplatform.services.jcr.webdav.command.PropFindCommand;
import org.exoplatform.services.jcr.webdav.command.PropPatchCommand;
import org.exoplatform.services.jcr.webdav.command.PutCommand;
import org.exoplatform.services.jcr.webdav.command.SearchCommand;
import org.exoplatform.services.jcr.webdav.command.UnLockCommand;
import org.exoplatform.services.jcr.webdav.command.deltav.CheckInCommand;
import org.exoplatform.services.jcr.webdav.command.deltav.CheckOutCommand;
import org.exoplatform.services.jcr.webdav.command.deltav.ReportCommand;
import org.exoplatform.services.jcr.webdav.command.deltav.UnCheckOutCommand;
import org.exoplatform.services.jcr.webdav.command.deltav.VersionControlCommand;
import org.exoplatform.services.jcr.webdav.lock.NullResourceLocksHolder;
import org.exoplatform.services.jcr.webdav.util.NodeTypeUtil;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ext.webdav.method.ACL;
import org.exoplatform.services.rest.ext.webdav.method.CHECKIN;
import org.exoplatform.services.rest.ext.webdav.method.CHECKOUT;
import org.exoplatform.services.rest.ext.webdav.method.COPY;
import org.exoplatform.services.rest.ext.webdav.method.LOCK;
import org.exoplatform.services.rest.ext.webdav.method.MKCOL;
import org.exoplatform.services.rest.ext.webdav.method.MOVE;
import org.exoplatform.services.rest.ext.webdav.method.OPTIONS;
import org.exoplatform.services.rest.ext.webdav.method.ORDERPATCH;
import org.exoplatform.services.rest.ext.webdav.method.PROPFIND;
import org.exoplatform.services.rest.ext.webdav.method.PROPPATCH;
import org.exoplatform.services.rest.ext.webdav.method.REPORT;
import org.exoplatform.services.rest.ext.webdav.method.SEARCH;
import org.exoplatform.services.rest.ext.webdav.method.UNCHECKOUT;
import org.exoplatform.services.rest.ext.webdav.method.UNLOCK;
import org.exoplatform.services.rest.ext.webdav.method.VERSIONCONTROL;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/jcr")
public class WebDavServiceImpl
implements WebDavService,
ResourceContainer {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.webdav.WebDavServiceImpl");
    private final SessionProviderService sessionProviderService;
    private final RepositoryService repositoryService;
    private final NullResourceLocksHolder nullResourceLocks;
    protected WebDavServiceInitParams webDavServiceInitParams;
    private static final String ALLOW;
    private Pattern pattern;
    private final MimeTypeResolver mimeTypeResolver;

    public WebDavServiceImpl(InitParams params, RepositoryService repositoryService, SessionProviderService sessionProviderService) throws Exception {
        this(repositoryService, sessionProviderService);
        this.webDavServiceInitParams = new WebDavServiceInitParams(params);
        this.pattern = StringUtils.isNotBlank((String)this.webDavServiceInitParams.getFolderListingAllowedRegex()) ? Pattern.compile(this.webDavServiceInitParams.getFolderListingAllowedRegex()) : null;
    }

    protected WebDavServiceImpl(Map<String, String> params, RepositoryService repositoryService, SessionProviderService sessionProviderService) throws Exception {
        this(repositoryService, sessionProviderService);
        this.webDavServiceInitParams = new WebDavServiceInitParams(params);
        this.pattern = StringUtils.isNotBlank((String)this.webDavServiceInitParams.getFolderListingAllowedRegex()) ? Pattern.compile(this.webDavServiceInitParams.getFolderListingAllowedRegex()) : null;
    }

    protected WebDavServiceImpl(RepositoryService repositoryService, SessionProviderService sessionProviderService) {
        this.sessionProviderService = sessionProviderService;
        this.repositoryService = repositoryService;
        this.nullResourceLocks = new NullResourceLocksHolder();
        this.mimeTypeResolver = new MimeTypeResolver();
        this.mimeTypeResolver.setDefaultMimeType("application/octet-stream");
        this.webDavServiceInitParams = new WebDavServiceInitParams();
        this.pattern = StringUtils.isNotBlank((String)this.webDavServiceInitParams.getFolderListingAllowedRegex()) ? Pattern.compile(this.webDavServiceInitParams.getFolderListingAllowedRegex()) : null;
    }

    @Override
    @CHECKIN
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response checkin(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("CHECKIN " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), this.lockTokens(lockTokenHeader, ifHeader));
            return new CheckInCommand().checkIn(session, this.path(repoPath));
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    @Override
    @CHECKOUT
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response checkout(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("CHECKOUT " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), this.lockTokens(lockTokenHeader, ifHeader));
            return new CheckOutCommand().checkout(session, this.path(repoPath));
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    @Override
    @COPY
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response copy(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="Destination") String destinationHeader, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="depth") String depthHeader, @HeaderParam(value="Overwrite") String overwriteHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        boolean itemExisted = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("COPY " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Session session;
            String serverURI = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).build(new Object[0]).toString();
            URI dest = this.buildURI(destinationHeader);
            URI base = this.buildURI(serverURI);
            String destPath = dest.getPath();
            int repoIndex = destPath.indexOf(repoName);
            if (dest.getHost() != null && !base.getHost().equals(dest.getHost())) {
                return Response.status((int)502).entity((Object)"Bad Gateway").build();
            }
            destPath = this.normalizePath(repoIndex == -1 ? destPath : destPath.substring(repoIndex + repoName.length() + 1));
            String srcWorkspace = this.workspaceName(repoPath);
            String srcNodePath = this.path(repoPath);
            String destWorkspace = this.workspaceName(destPath);
            String destNodePath = this.path(destPath, false);
            List<String> lockTokens = this.lockTokens(lockTokenHeader, ifHeader);
            Depth depth = new Depth(depthHeader);
            boolean overwrite = true;
            if (overwriteHeader != null && overwriteHeader.equalsIgnoreCase("F")) {
                overwrite = false;
            }
            repoName = this.getRepositoryName(repoName);
            if (overwrite) {
                Response delResponse = this.delete(repoName, destPath, lockTokenHeader, ifHeader);
                itemExisted = delResponse.getStatus() == 204;
            } else {
                session = this.session(repoName, srcWorkspace, null);
                if (session.getRootNode().hasNode(TextUtil.relativizePath(this.path(destPath)))) {
                    return Response.status((int)412).entity((Object)"Item exists on destination path, while overwriting is forbidden").build();
                }
            }
            if (depth.getStringValue().equalsIgnoreCase("infinity")) {
                if (srcWorkspace.equals(destWorkspace)) {
                    session = this.session(repoName, destWorkspace, lockTokens);
                    return new CopyCommand(uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName), itemExisted).copy(session, srcNodePath, destNodePath);
                }
                Session destSession = this.session(repoName, destWorkspace, lockTokens);
                return new CopyCommand(uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName), itemExisted).copy(destSession, srcWorkspace, srcNodePath, destNodePath);
            }
            if (depth.getIntValue() == 0) {
                int nodeNameStart = srcNodePath.lastIndexOf(47) + 1;
                String nodeName = srcNodePath.substring(nodeNameStart);
                int indexStart = nodeName.indexOf(91);
                if (indexStart != -1) {
                    nodeName = nodeName.substring(0, indexStart);
                }
                Session session2 = this.session(repoName, destWorkspace, lockTokens);
                return new MkColCommand(this.nullResourceLocks, uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName)).mkCol(session2, destNodePath + "/" + nodeName, this.webDavServiceInitParams.getDefaultFolderNodeType(), null, lockTokens);
            }
            return Response.status((int)400).entity((Object)"Bad Request").build();
        }
        catch (PreconditionException exc) {
            return Response.status((int)400).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException e) {
            log.error((Object)("NoSuchWorkspaceException " + e.getMessage()), (Throwable)e);
            return Response.status((int)409).entity((Object)e.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    @Override
    @DELETE
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response delete(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("DELETE " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), this.lockTokens(lockTokenHeader, ifHeader));
            if (lockTokenHeader != null && (lockTokenHeader = lockTokenHeader.substring(1, lockTokenHeader.length() - 1)).contains("opaquelocktoken")) {
                lockTokenHeader = lockTokenHeader.split(":")[1];
            }
            return new DeleteCommand().delete(session, this.path(repoPath), lockTokenHeader);
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    @Override
    @GET
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response get(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="Range") String rangeHeader, @HeaderParam(value="If-Modified-Since") String ifModifiedSince, @HeaderParam(value="If-None-Match") String ifNoneMatch, @QueryParam(value="version") String version, @Context UriInfo uriInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("GET " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            repoName = this.getRepositoryName(repoName);
            String workspaceName = this.workspaceName(repoPath);
            String path = this.path(repoPath);
            if (!this.isAllowedPath(workspaceName, path)) {
                return Response.status((int)404).build();
            }
            Session session = this.session(repoName, workspaceName, null);
            ArrayList<Range> ranges = new ArrayList<Range>();
            if (rangeHeader != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)rangeHeader);
                }
                if (rangeHeader.startsWith("bytes=")) {
                    String[] tokens;
                    String rangeString = rangeHeader.substring(rangeHeader.indexOf("=") + 1);
                    for (String token : tokens = rangeString.split(",")) {
                        Range range = new Range();
                        int dash = (token = token.trim()).indexOf("-");
                        if (dash == -1) {
                            return Response.status((int)416).entity((Object)"Requested Range Not Satisfiable").build();
                        }
                        if (dash == 0) {
                            range.setStart(Long.parseLong(token));
                            range.setEnd(-1L);
                        } else if (dash > 0) {
                            range.setStart(Long.parseLong(token.substring(0, dash)));
                            if (dash < token.length() - 1) {
                                range.setEnd(Long.parseLong(token.substring(dash + 1, token.length())));
                            } else {
                                range.setEnd(-1L);
                            }
                        }
                        ranges.add(range);
                    }
                }
            }
            String uri = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).path(this.workspaceName(repoPath)).build(new Object[0]).toString();
            return new GetCommand(this.webDavServiceInitParams.getXsltParams()).get(session, path, version, uri, ranges, ifModifiedSince, ifNoneMatch, this.webDavServiceInitParams.getCacheControlMap());
        }
        catch (PathNotFoundException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    @Override
    @HEAD
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response head(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @Context UriInfo uriInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("HEAD " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            repoName = this.getRepositoryName(repoName);
            Session session = this.session(repoName, this.workspaceName(repoPath), null);
            String uri = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).path(this.workspaceName(repoPath)).build(new Object[0]).toString();
            return new HeadCommand().head(session, this.path(repoPath), uri);
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    @Override
    @LOCK
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response lock(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="depth") String depthHeader, HierarchicalProperty body) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("LOCK " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), this.lockTokens(lockTokenHeader, ifHeader));
            return new LockCommand(this.nullResourceLocks).lock(session, this.path(repoPath), body, new Depth(depthHeader), "86400");
        }
        catch (PreconditionException exc) {
            log.error((Object)("PreconditionException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)412).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)409).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    @Override
    @UNLOCK
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response unlock(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("UNLOCK " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        List<String> tokens = this.lockTokens(lockTokenHeader, ifHeader);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), tokens);
            return new UnLockCommand(this.nullResourceLocks).unLock(session, this.path(repoPath), tokens);
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    @Override
    @MKCOL
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response mkcol(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="Folder-NodeType") String folderNodeTypeHeader, @HeaderParam(value="Content-MixinTypes") String mixinTypesHeader, @Context UriInfo uriInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("MKCOL " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            repoName = this.getRepositoryName(repoName);
            List<String> tokens = this.lockTokens(lockTokenHeader, ifHeader);
            Session session = this.session(repoName, this.workspaceName(repoPath), tokens);
            String folderNodeType = NodeTypeUtil.getNodeType(folderNodeTypeHeader, this.webDavServiceInitParams.getDefaultFolderNodeType(), this.webDavServiceInitParams.getAllowedFolderNodeTypes());
            return new MkColCommand(this.nullResourceLocks, uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName)).mkCol(session, this.path(repoPath, false), folderNodeType, NodeTypeUtil.getMixinTypes(mixinTypesHeader), tokens);
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)409).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchNodeTypeException exc) {
            log.error((Object)("NoSuchNodeTypeException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)415).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    @Override
    @MOVE
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response move(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="Destination") String destinationHeader, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="depth") String depthHeader, @HeaderParam(value="Overwrite") String overwriteHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        boolean itemExisted = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("MOVE " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Session session;
            String serverURI = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).build(new Object[0]).toString();
            URI dest = this.buildURI(destinationHeader);
            URI base = this.buildURI(serverURI);
            String destPath = dest.getPath();
            int repoIndex = destPath.indexOf(repoName);
            if (dest.getHost() != null && !base.getHost().equals(dest.getHost())) {
                return Response.status((int)502).entity((Object)"Bad Gateway").build();
            }
            destPath = this.normalizePath(repoIndex == -1 ? destPath : destPath.substring(repoIndex + repoName.length() + 1));
            String destWorkspace = this.workspaceName(destPath);
            String destNodePath = this.path(destPath, false);
            String srcWorkspace = this.workspaceName(repoPath);
            String srcNodePath = this.path(repoPath);
            List<String> lockTokens = this.lockTokens(lockTokenHeader, ifHeader);
            Depth depth = new Depth(depthHeader);
            boolean overwrite = true;
            if (overwriteHeader != null && overwriteHeader.equalsIgnoreCase("F")) {
                overwrite = false;
            }
            repoName = this.getRepositoryName(repoName);
            if (overwrite) {
                Response delResponse = this.delete(repoName, destPath, lockTokenHeader, ifHeader);
                itemExisted = delResponse.getStatus() == 204;
            } else {
                session = this.session(repoName, srcWorkspace, null);
                String uri = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).path(srcWorkspace).build(new Object[0]).toString();
                Response prpfind = new PropFindCommand().propfind(session, this.path(destPath), body, depth.getIntValue(), uri);
                if (prpfind.getStatus() != 404) {
                    return Response.status((int)412).entity((Object)"Item exists on destination path, while overwriting is forbidden").build();
                }
            }
            if (depth.getStringValue().equalsIgnoreCase("Infinity")) {
                if (srcWorkspace.equals(destWorkspace)) {
                    session = this.session(repoName, srcWorkspace, lockTokens);
                    return new MoveCommand(uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName), itemExisted).move(session, srcNodePath, destNodePath);
                }
                Session srcSession = this.session(repoName, srcWorkspace, lockTokens);
                Session destSession = this.session(repoName, destWorkspace, lockTokens);
                return new MoveCommand(uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName), itemExisted).move(srcSession, destSession, srcNodePath, destNodePath);
            }
            return Response.status((int)400).entity((Object)"Bad Request").build();
        }
        catch (NoSuchWorkspaceException e) {
            log.error((Object)("NoSuchWorkspaceException " + e.getMessage()), (Throwable)e);
            return Response.status((int)409).entity((Object)e.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    @Override
    @OPTIONS
    @Path(value="/{repoName}/{path:.*}/")
    public Response options(@PathParam(value="path") String path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("OPTIONS " + path));
        }
        String DASL_VALUE = "<DAV:basicsearch><exo:sql xmlns:exo=\"http://exoplatform.com/jcr\"/><exo:xpath xmlns:exo=\"http://exoplatform.com/jcr\"/>";
        return Response.ok().header("Allow", (Object)ALLOW).header("DAV", (Object)"1, 2, ordered-collections, access-control").header("DASL", (Object)DASL_VALUE).header("MS-Author-Via", (Object)"DAV").build();
    }

    @Override
    @ORDERPATCH
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response order(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ORDERPATCH " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            repoName = this.getRepositoryName(repoName);
            List<String> lockTokens = this.lockTokens(lockTokenHeader, ifHeader);
            Session session = this.session(repoName, this.workspaceName(repoPath), lockTokens);
            String uri = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).path(this.workspaceName(repoPath)).build(new Object[0]).toString();
            return new OrderPatchCommand().orderPatch(session, this.path(repoPath), body, uri);
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    @Override
    @PROPFIND
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response propfind(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="depth") String depthHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("PROPFIND " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            repoName = this.getRepositoryName(repoName);
            String workspaceName = this.workspaceName(repoPath);
            String path = this.path(repoPath);
            if (!this.isAllowedPath(workspaceName, path)) {
                return Response.status((int)404).build();
            }
            Session session = this.session(repoName, workspaceName, null);
            String uri = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).path(workspaceName).build(new Object[0]).toString();
            Depth depth = new Depth(depthHeader);
            return new PropFindCommand().propfind(session, path, body, depth.getIntValue(), uri);
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)409).entity((Object)exc.getMessage()).build();
        }
        catch (PreconditionException exc) {
            return Response.status((int)400).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    @Override
    @PROPPATCH
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response proppatch(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("PROPPATCH " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            repoName = this.getRepositoryName(repoName);
            List<String> lockTokens = this.lockTokens(lockTokenHeader, ifHeader);
            Session session = this.session(repoName, this.workspaceName(repoPath), lockTokens);
            String uri = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).path(this.workspaceName(repoPath)).build(new Object[0]).toString();
            return new PropPatchCommand(this.nullResourceLocks).propPatch(session, this.path(repoPath), body, lockTokens, uri);
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspace. " + exc.getMessage()));
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    @Override
    @PUT
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response put(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="File-NodeType") String fileNodeTypeHeader, @HeaderParam(value="Content-NodeType") String contentNodeTypeHeader, @HeaderParam(value="Content-MixinTypes") String mixinTypes, @HeaderParam(value="Content-Type") MediaType mediaType, @HeaderParam(value="User-Agent") String userAgent, InputStream inputStream, @Context UriInfo uriInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("PUT " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        MimeTypeRecognizer mimeTypeRecognizer = new MimeTypeRecognizer(TextUtil.nameOnly(repoPath), this.mimeTypeResolver, mediaType, this.webDavServiceInitParams.isUntrustedUserAgent(userAgent));
        try {
            repoName = this.getRepositoryName(repoName);
            List<String> tokens = this.lockTokens(lockTokenHeader, ifHeader);
            Session session = this.session(repoName, this.workspaceName(repoPath), tokens);
            String fileNodeType = NodeTypeUtil.getNodeType(fileNodeTypeHeader, this.webDavServiceInitParams.getDefaultFileNodeType(), this.webDavServiceInitParams.getAllowedFileNodeTypes());
            String contentNodeType = NodeTypeUtil.getContentNodeType(contentNodeTypeHeader);
            NodeTypeManager ntm = session.getWorkspace().getNodeTypeManager();
            NodeType nodeType = ntm.getNodeType(contentNodeType);
            NodeTypeUtil.checkContentResourceType(nodeType);
            if (this.webDavServiceInitParams.isEnableAutoVersion()) {
                return new PutCommand(this.nullResourceLocks, uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName), mimeTypeRecognizer).put(session, this.path(repoPath), inputStream, fileNodeType, contentNodeType, NodeTypeUtil.getMixinTypes(mixinTypes), tokens, this.webDavServiceInitParams.getAllowedAutoVersionPath());
            }
            return new PutCommand(this.nullResourceLocks, uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName), mimeTypeRecognizer).put(session, this.path(repoPath), inputStream, fileNodeType, contentNodeType, NodeTypeUtil.getMixinTypes(mixinTypes), this.webDavServiceInitParams.getDefaultUpdatePolicyType(), this.webDavServiceInitParams.getDefaultAutoVersionType(), tokens);
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)409).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchNodeTypeException exc) {
            log.error((Object)("NoSuchNodeTypeException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)400).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    @Override
    @REPORT
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response report(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="depth") String depthHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("REPORT " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            repoName = this.getRepositoryName(repoName);
            Depth depth = new Depth(depthHeader);
            Session session = this.session(repoName, this.workspaceName(repoPath), null);
            String uri = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).path(this.workspaceName(repoPath)).build(new Object[0]).toString();
            return new ReportCommand().report(session, this.path(repoPath), body, depth, uri);
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    @Override
    @SEARCH
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response search(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @Context UriInfo uriInfo, HierarchicalProperty body) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SEARCH " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            repoName = this.getRepositoryName(repoName);
            String workspaceName = this.workspaceName(repoPath);
            String path = this.path(repoPath);
            if (!this.isAllowedPath(workspaceName, path)) {
                return Response.status((int)404).build();
            }
            Session session = this.session(repoName, workspaceName, null);
            String uri = uriInfo.getBaseUriBuilder().path(this.getClass()).path(repoName).path(workspaceName).build(new Object[0]).toString();
            return new SearchCommand().search(session, body, uri);
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    @Override
    @UNCHECKOUT
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response uncheckout(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("UNCHECKOUT " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), this.lockTokens(lockTokenHeader, ifHeader));
            return new UnCheckOutCommand().uncheckout(session, this.path(repoPath));
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    @Override
    @VERSIONCONTROL
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response versionControl(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        Session session;
        if (log.isDebugEnabled()) {
            log.debug((Object)("VERSION-CONTROL " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            session = this.session(repoName, this.workspaceName(repoPath), this.lockTokens(lockTokenHeader, ifHeader));
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
        return new VersionControlCommand().versionControl(session, this.path(repoPath));
    }

    @Override
    @ACL
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response acl(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, HierarchicalProperty body) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ACL " + repoName + "/" + repoPath));
        }
        repoPath = this.normalizePath(repoPath);
        try {
            List<String> lockTokens = this.lockTokens(lockTokenHeader, ifHeader);
            Session session = this.session(repoName, this.workspaceName(repoPath), lockTokens);
            return new AclCommand().acl(session, this.path(repoPath), body);
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspace. " + exc.getMessage()));
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.status((int)500).entity((Object)exc.getMessage()).build();
        }
    }

    protected Session session(String repoName, String wsName, List<String> lockTokens) throws Exception, NoSuchWorkspaceException {
        SessionProvider sp;
        String currentRepositoryName;
        ManageableRepository repo = this.repositoryService.getCurrentRepository();
        if (PropertyManager.isDevelopping() && log.isWarnEnabled() && !(currentRepositoryName = repo.getConfiguration().getName()).equals(repoName)) {
            log.warn((Object)("The expected repository was '" + repoName + "' but we will use the current repository instead which is '" + currentRepositoryName + "'"));
        }
        if ((sp = this.sessionProviderService.getSessionProvider(null)) == null) {
            throw new RepositoryException("SessionProvider is not properly set. Make the application callsSessionProviderService.setSessionProvider(..) somewhere before (for instance in Servlet Filter for WEB application)");
        }
        Session session = sp.getSession(wsName, repo);
        if (lockTokens != null) {
            int i;
            String[] presentLockTokens = session.getLockTokens();
            ArrayList<String> presentLockTokensList = new ArrayList<String>();
            for (i = 0; i < presentLockTokens.length; ++i) {
                presentLockTokensList.add(presentLockTokens[i]);
            }
            for (i = 0; i < lockTokens.size(); ++i) {
                String lockToken = lockTokens.get(i);
                if (presentLockTokensList.contains(lockToken)) continue;
                session.addLockToken(lockToken);
            }
        }
        return session;
    }

    protected String getRepositoryName(String repoName) throws RepositoryException {
        ManageableRepository repo = this.repositoryService.getCurrentRepository();
        String currentRepositoryName = repo.getConfiguration().getName();
        if (PropertyManager.isDevelopping() && log.isWarnEnabled() && !currentRepositoryName.equals(repoName)) {
            log.warn((Object)("The expected repository was '" + repoName + "' but we will use the current repository instead which is '" + currentRepositoryName + "'"));
        }
        return currentRepositoryName;
    }

    protected String workspaceName(String repoPath) {
        return repoPath.split("/")[0];
    }

    protected String normalizePath(String repoPath) {
        if (repoPath.length() > 0 && repoPath.endsWith("/")) {
            return repoPath.substring(0, repoPath.length() - 1);
        }
        return repoPath;
    }

    protected String path(String repoPath) {
        return this.path(repoPath, true);
    }

    protected String path(String repoPath, boolean withIndex) {
        String path = repoPath.substring(this.workspaceName(repoPath).length());
        if (path.length() > 0) {
            if (!withIndex) {
                return TextUtil.removeIndexFromPath(path);
            }
            return path;
        }
        return "/";
    }

    protected List<String> lockTokens(String lockTokenHeader, String ifHeader) {
        ArrayList<String> lockTokens = new ArrayList<String>();
        if (lockTokenHeader != null) {
            if (lockTokenHeader.startsWith("<")) {
                lockTokenHeader = lockTokenHeader.substring(1, lockTokenHeader.length() - 1);
            }
            if (lockTokenHeader.contains("opaquelocktoken")) {
                lockTokenHeader = lockTokenHeader.split(":")[1];
            }
            lockTokens.add(lockTokenHeader);
        }
        if (ifHeader != null) {
            String headerLockToken = ifHeader.substring(ifHeader.indexOf("("));
            if ((headerLockToken = headerLockToken.substring(2, headerLockToken.length() - 2)).contains("opaquelocktoken")) {
                headerLockToken = headerLockToken.split(":")[1];
            }
            lockTokens.add(headerLockToken);
        }
        return lockTokens;
    }

    private URI buildURI(String path) throws URISyntaxException {
        try {
            return new URI(path);
        }
        catch (URISyntaxException e) {
            return new URI(TextUtil.escape(path, '%', true));
        }
    }

    private boolean isAllowedPath(String workspaceName, String path) {
        if (this.pattern == null) {
            return true;
        }
        Matcher matcher = this.pattern.matcher(workspaceName + ":" + path);
        if (!matcher.find()) {
            log.warn("Access not allowed to webdav resource {} with pattern {}", new Object[]{workspaceName + ":" + path, this.pattern.toString()});
            return false;
        }
        return true;
    }

    static {
        StringBuffer sb = new StringBuffer();
        for (Method m : WebDavServiceImpl.class.getMethods()) {
            for (Annotation a : m.getAnnotations()) {
                HttpMethod ma = null;
                ma = a.annotationType().getAnnotation(HttpMethod.class);
                if (ma == null) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(ma.value());
            }
        }
        ALLOW = sb.toString();
    }
}

