/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.SecurityContext;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.webdav.BaseStandaloneTest;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.impl.RequestHandlerImpl;
import org.exoplatform.services.rest.tools.DummySecurityContext;
import org.exoplatform.services.rest.tools.ResourceLauncher;
import org.exoplatform.services.security.IdentityConstants;

public class TestAclCommand
extends BaseStandaloneTest {
    private final String USER_ONE = "Oksana";
    private final String USER_TWO = "Anya";
    private final String USER_ROOT = "root";
    private final String BASE_URI = "http://localhost";
    private final String TEST_NODE_NAME = "test_node" + System.currentTimeMillis();

    public void testSetACLForTwoUsersOnNonPrivilegeableResource() throws Exception {
        this.testSetACLForTwoUsersOnNonPrivilegeableResource(this.getPathWS());
    }

    public void testSetACLForTwoUsersOnNonPrivilegeableResourceWithFakePathWS() throws Exception {
        this.testSetACLForTwoUsersOnNonPrivilegeableResource(this.getFakePathWS());
    }

    private void testSetACLForTwoUsersOnNonPrivilegeableResource(String pathWs) throws Exception {
        this.root.addNode(this.TEST_NODE_NAME);
        NodeImpl testNode = (NodeImpl)this.root.addNode(this.TEST_NODE_NAME, "nt:folder");
        this.session.save();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Depth", (Object)"0");
        headers.putSingle((Object)"Content-Type", (Object)"text/xml; charset=\"utf-8\"");
        EnvironmentContext ctx = new EnvironmentContext();
        HashSet<String> adminRoles = new HashSet<String>();
        adminRoles.add("administrators");
        DummySecurityContext adminSecurityContext = new DummySecurityContext(new Principal(){

            @Override
            public String getName() {
                return "root";
            }
        }, adminRoles);
        ctx.put(SecurityContext.class, (Object)adminSecurityContext);
        RequestHandlerImpl handler = (RequestHandlerImpl)this.container.getComponentInstanceOfType(RequestHandlerImpl.class);
        ResourceLauncher launcher = new ResourceLauncher((RequestHandler)handler);
        String request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:acl xmlns:D=\"DAV:\"><D:ace><D:principal><D:href>Oksana</D:href></D:principal><D:grant><D:privilege><D:write/></D:privilege></D:grant></D:ace><D:ace><D:principal><D:href>Anya</D:href></D:principal><D:grant><D:write/></D:grant></D:ace></D:acl>";
        ContainerResponse response = launcher.service("ACL", this.escape(pathWs + testNode.getPath()), "http://localhost", (Map)headers, request.getBytes(), null, ctx);
        TestAclCommand.assertEquals((int)200, (int)response.getStatus());
        this.session.refresh(false);
        testNode = (NodeImpl)this.root.getNode(this.TEST_NODE_NAME + "[2]");
        testNode.setPermission("root", new String[]{"read", "add_node", "set_property", "remove"});
        testNode.removePermission(IdentityConstants.ANY);
        this.session.save();
        this.checkPermissionSet(testNode, "Oksana", "add_node");
        this.checkPermissionSet(testNode, "Oksana", "set_property");
        this.checkPermissionSet(testNode, "Oksana", "remove");
        this.checkPermissionSet(testNode, "Anya", "add_node");
        this.checkPermissionSet(testNode, "Anya", "set_property");
        this.checkPermissionSet(testNode, "Anya", "remove");
        testNode.remove();
        this.session.save();
    }

    public void testDenyPermissionOnPrivilegeableResource() throws Exception {
        this.root.addNode(this.TEST_NODE_NAME);
        NodeImpl testNode = (NodeImpl)this.root.addNode(this.TEST_NODE_NAME, "nt:folder");
        testNode.addMixin("mix:versionable");
        testNode.addMixin("exo:privilegeable");
        testNode.setPermission("root", new String[]{"read", "add_node", "set_property", "remove"});
        testNode.setPermission("Oksana", new String[]{"add_node", "set_property", "remove"});
        testNode.removePermission(IdentityConstants.ANY);
        this.session.save();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Depth", (Object)"0");
        headers.putSingle((Object)"Content-Type", (Object)"text/xml; charset=\"utf-8\"");
        EnvironmentContext ctx = new EnvironmentContext();
        HashSet<String> adminRoles = new HashSet<String>();
        adminRoles.add("administrators");
        DummySecurityContext adminSecurityContext = new DummySecurityContext(new Principal(){

            @Override
            public String getName() {
                return "root";
            }
        }, adminRoles);
        ctx.put(SecurityContext.class, (Object)adminSecurityContext);
        RequestHandlerImpl handler = (RequestHandlerImpl)this.container.getComponentInstanceOfType(RequestHandlerImpl.class);
        ResourceLauncher launcher = new ResourceLauncher((RequestHandler)handler);
        String request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:acl xmlns:D=\"DAV:\"><D:ace><D:principal><D:href>Oksana</D:href></D:principal><D:deny><D:privilege><D:write/></D:privilege></D:deny></D:ace></D:acl>";
        ContainerResponse response = launcher.service("ACL", this.escape(this.getPathWS() + testNode.getPath()), "http://localhost", (Map)headers, request.getBytes(), null, ctx);
        TestAclCommand.assertEquals((int)200, (int)response.getStatus());
        this.session.refresh(false);
        testNode = (NodeImpl)this.root.getNode(this.TEST_NODE_NAME + "[2]");
        this.checkPermissionRemoved(testNode, "Oksana", "add_node");
        this.checkPermissionRemoved(testNode, "Oksana", "set_property");
        this.checkPermissionRemoved(testNode, "Oksana", "remove");
        testNode.remove();
        this.session.save();
    }

    public void testDenyAndGrantInASingleACE() throws Exception {
        this.root.addNode(this.TEST_NODE_NAME);
        NodeImpl testNode = (NodeImpl)this.root.addNode(this.TEST_NODE_NAME, "nt:folder");
        testNode.addMixin("mix:versionable");
        testNode.addMixin("exo:privilegeable");
        testNode.setPermission("root", new String[]{"read", "add_node", "set_property", "remove"});
        testNode.removePermission(IdentityConstants.ANY);
        this.session.save();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Depth", (Object)"0");
        headers.putSingle((Object)"Content-Type", (Object)"text/xml; charset=\"utf-8\"");
        EnvironmentContext ctx = new EnvironmentContext();
        HashSet<String> adminRoles = new HashSet<String>();
        adminRoles.add("administrators");
        DummySecurityContext adminSecurityContext = new DummySecurityContext(new Principal(){

            @Override
            public String getName() {
                return "root";
            }
        }, adminRoles);
        ctx.put(SecurityContext.class, (Object)adminSecurityContext);
        RequestHandlerImpl handler = (RequestHandlerImpl)this.container.getComponentInstanceOfType(RequestHandlerImpl.class);
        ResourceLauncher launcher = new ResourceLauncher((RequestHandler)handler);
        String request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:acl xmlns:D=\"DAV:\"><D:ace><D:principal><D:href>Oksana</D:href></D:principal><D:deny><D:privilege><D:write/></D:privilege></D:deny><D:grant><D:privilege><D:write/></D:privilege></D:grant></D:ace></D:acl>";
        ContainerResponse response = launcher.service("ACL", this.escape(this.getPathWS() + testNode.getPath()), "http://localhost", (Map)headers, request.getBytes(), null, ctx);
        TestAclCommand.assertEquals((int)400, (int)response.getStatus());
        testNode.remove();
        this.session.save();
    }

    public void testSetAllPermissionsForAllUsersOnPrivilegeableResource() throws Exception {
        this.root.addNode(this.TEST_NODE_NAME);
        NodeImpl testNode = (NodeImpl)this.root.addNode(this.TEST_NODE_NAME, "nt:folder");
        testNode.addMixin("exo:owneable");
        testNode.addMixin("exo:privilegeable");
        this.session.save();
        HashMap<String, String[]> defaultPermissions = new HashMap<String, String[]>();
        String[] initPermissions = new String[]{"add_node", "read", "set_property"};
        defaultPermissions.put("Anya", initPermissions);
        testNode.setPermissions(defaultPermissions);
        this.session.save();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Depth", (Object)"0");
        headers.putSingle((Object)"Content-Type", (Object)"text/xml; charset=\"utf-8\"");
        EnvironmentContext ctx = new EnvironmentContext();
        HashSet<String> adminRoles = new HashSet<String>();
        adminRoles.add("administrators");
        DummySecurityContext adminSecurityContext = new DummySecurityContext(new Principal(){

            @Override
            public String getName() {
                return "root";
            }
        }, adminRoles);
        ctx.put(SecurityContext.class, (Object)adminSecurityContext);
        RequestHandlerImpl handler = (RequestHandlerImpl)this.container.getComponentInstanceOfType(RequestHandlerImpl.class);
        ResourceLauncher launcher = new ResourceLauncher((RequestHandler)handler);
        String request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:acl xmlns:D=\"DAV:\"><D:ace><D:principal><D:all /></D:principal><D:grant><D:privilege><D:all/></D:privilege></D:grant></D:ace></D:acl>";
        ContainerResponse response = launcher.service("ACL", this.escape(this.getPathWS() + testNode.getPath()), "http://localhost", (Map)headers, request.getBytes(), null, ctx);
        TestAclCommand.assertEquals((int)200, (int)response.getStatus());
        this.session.refresh(false);
        testNode = (NodeImpl)this.root.getNode(this.TEST_NODE_NAME + "[2]");
        this.checkPermissionSet(testNode, IdentityConstants.ANY, "add_node");
        this.checkPermissionSet(testNode, IdentityConstants.ANY, "set_property");
        this.checkPermissionSet(testNode, IdentityConstants.ANY, "remove");
        this.checkPermissionSet(testNode, IdentityConstants.ANY, "read");
        testNode.remove();
        this.session.save();
    }

    public void testWrongGrantElementAceElementInAclBody() throws Exception {
        this.root.addNode(this.TEST_NODE_NAME);
        NodeImpl testNode = (NodeImpl)this.root.addNode(this.TEST_NODE_NAME, "nt:folder");
        testNode.addMixin("exo:owneable");
        testNode.addMixin("exo:privilegeable");
        testNode.setPermission("root", new String[]{"read", "add_node", "set_property", "remove"});
        testNode.removePermission(IdentityConstants.ANY);
        this.session.save();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Depth", (Object)"0");
        headers.putSingle((Object)"Content-Type", (Object)"text/xml; charset=\"utf-8\"");
        EnvironmentContext ctx = new EnvironmentContext();
        HashSet<String> adminRoles = new HashSet<String>();
        adminRoles.add("administrators");
        DummySecurityContext adminSecurityContext = new DummySecurityContext(new Principal(){

            @Override
            public String getName() {
                return "root";
            }
        }, adminRoles);
        ctx.put(SecurityContext.class, (Object)adminSecurityContext);
        RequestHandlerImpl handler = (RequestHandlerImpl)this.container.getComponentInstanceOfType(RequestHandlerImpl.class);
        ResourceLauncher launcher = new ResourceLauncher((RequestHandler)handler);
        String request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:acl xmlns:D=\"DAV:\"><D:ace><D:principal><D:all /></D:principal><D:grant><D:privilege><D:read /><D:write /></D:privilege></D:grant></D:ace></D:acl>";
        ContainerResponse response = launcher.service("ACL", this.escape(this.getPathWS() + testNode.getPath()), "http://localhost", (Map)headers, request.getBytes(), null, ctx);
        TestAclCommand.assertEquals((int)400, (int)response.getStatus());
        request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:acl xmlns:D=\"DAV:\"><D:ace><D:principal><D:all /></D:principal><D:grant></D:grant></D:ace></D:acl>";
        response = launcher.service("ACL", this.escape(this.getPathWS() + testNode.getPath()), "http://localhost", (Map)headers, request.getBytes(), null, ctx);
        TestAclCommand.assertEquals((int)400, (int)response.getStatus());
        request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:acl xmlns:D=\"DAV:\"><D:ace><D:principal><D:all /></D:principal><D:grant><D:privilege></D:privilege></D:grant></D:ace></D:acl>";
        response = launcher.service("ACL", this.escape(this.getPathWS() + testNode.getPath()), "http://localhost", (Map)headers, request.getBytes(), null, ctx);
        TestAclCommand.assertEquals((int)400, (int)response.getStatus());
        testNode.remove();
        this.session.save();
    }

    public void testWrongAceElementInAclBody() throws Exception {
        this.root.addNode(this.TEST_NODE_NAME);
        NodeImpl testNode = (NodeImpl)this.root.addNode(this.TEST_NODE_NAME, "nt:folder");
        this.session.save();
        testNode.addMixin("exo:owneable");
        testNode.addMixin("exo:privilegeable");
        this.session.save();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Depth", (Object)"0");
        headers.putSingle((Object)"Content-Type", (Object)"text/xml; charset=\"utf-8\"");
        EnvironmentContext ctx = new EnvironmentContext();
        HashSet<String> adminRoles = new HashSet<String>();
        adminRoles.add("administrators");
        DummySecurityContext adminSecurityContext = new DummySecurityContext(new Principal(){

            @Override
            public String getName() {
                return "root";
            }
        }, adminRoles);
        ctx.put(SecurityContext.class, (Object)adminSecurityContext);
        RequestHandlerImpl handler = (RequestHandlerImpl)this.container.getComponentInstanceOfType(RequestHandlerImpl.class);
        ResourceLauncher launcher = new ResourceLauncher((RequestHandler)handler);
        String request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:acl xmlns:D=\"DAV:\"><D:ace></D:ace></D:acl>";
        ContainerResponse response = launcher.service("ACL", this.escape(this.getPathWS() + testNode.getPath()), "http://localhost", (Map)headers, request.getBytes(), null, ctx);
        TestAclCommand.assertEquals((int)400, (int)response.getStatus());
        request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:acl xmlns:D=\"DAV:\"><D:ace><D:grant><D:privilege><D:read /><D:write /></D:privilege></D:grant></D:ace></D:acl>";
        response = launcher.service("ACL", this.escape(this.getPathWS() + testNode.getPath()), "http://localhost", (Map)headers, request.getBytes(), null, ctx);
        TestAclCommand.assertEquals((int)400, (int)response.getStatus());
        request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:acl xmlns:D=\"DAV:\"><D:ace><D:principal><D:all /></D:principal></D:ace></D:acl>";
        response = launcher.service("ACL", this.escape(this.getPathWS() + testNode.getPath()), "http://localhost", (Map)headers, request.getBytes(), null, ctx);
        TestAclCommand.assertEquals((int)400, (int)response.getStatus());
        testNode.remove();
        this.session.save();
    }

    public void testWrongPrincipalElementInAclBody() throws Exception {
        this.root.addNode(this.TEST_NODE_NAME);
        NodeImpl testNode = (NodeImpl)this.root.addNode(this.TEST_NODE_NAME, "nt:folder");
        this.session.save();
        testNode.addMixin("exo:owneable");
        testNode.addMixin("exo:privilegeable");
        this.session.save();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Depth", (Object)"0");
        headers.putSingle((Object)"Content-Type", (Object)"text/xml; charset=\"utf-8\"");
        EnvironmentContext ctx = new EnvironmentContext();
        HashSet<String> adminRoles = new HashSet<String>();
        adminRoles.add("administrators");
        DummySecurityContext adminSecurityContext = new DummySecurityContext(new Principal(){

            @Override
            public String getName() {
                return "root";
            }
        }, adminRoles);
        ctx.put(SecurityContext.class, (Object)adminSecurityContext);
        RequestHandlerImpl handler = (RequestHandlerImpl)this.container.getComponentInstanceOfType(RequestHandlerImpl.class);
        ResourceLauncher launcher = new ResourceLauncher((RequestHandler)handler);
        String request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:acl xmlns:D=\"DAV:\"><D:ace><D:principal></D:principal><D:grant><D:privilege><D:read /><D:write /></D:privilege></D:grant></D:ace></D:acl>";
        ContainerResponse response = launcher.service("ACL", this.escape(this.getPathWS() + testNode.getPath()), "http://localhost", (Map)headers, request.getBytes(), null, ctx);
        TestAclCommand.assertEquals((int)400, (int)response.getStatus());
        request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:acl xmlns:D=\"DAV:\"><D:ace><D:principal><D:all /></D:principal><D:grant><D:privilege><D:read /><D:write /></D:privilege></D:grant></D:ace></D:acl>";
        response = launcher.service("ACL", this.escape(this.getPathWS() + testNode.getPath()), "http://localhost", (Map)headers, request.getBytes(), null, ctx);
        TestAclCommand.assertEquals((int)400, (int)response.getStatus());
        request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:acl xmlns:D=\"DAV:\"><D:ace><D:principal><D:href></D:href></D:principal><D:grant><D:privilege><D:read /><D:write /></D:privilege></D:grant></D:ace></D:acl>";
        response = launcher.service("ACL", this.escape(this.getPathWS() + testNode.getPath()), "http://localhost", (Map)headers, request.getBytes(), null, ctx);
        TestAclCommand.assertEquals((int)400, (int)response.getStatus());
        request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:acl xmlns:D=\"DAV:\"><D:ace><D:principal><D:href>Oksana</D:href><href>Anya</href></D:principal><D:grant><D:privilege><D:read /><D:write /></D:privilege></D:grant></D:ace></D:acl>";
        response = launcher.service("ACL", this.escape(this.getPathWS() + testNode.getPath()), "http://localhost", (Map)headers, request.getBytes(), null, ctx);
        TestAclCommand.assertEquals((int)400, (int)response.getStatus());
        testNode.remove();
        this.session.save();
    }

    public void testSetAclForVersionableOwneablePrivilegeableCheckedOutNode() throws Exception {
        this.root.addNode(this.TEST_NODE_NAME);
        NodeImpl testNode = (NodeImpl)this.root.addNode(this.TEST_NODE_NAME, "nt:folder");
        this.session.save();
        testNode.addMixin("exo:owneable");
        testNode.addMixin("exo:privilegeable");
        testNode.addMixin("mix:versionable");
        testNode.setPermission("root", new String[]{"read", "add_node", "set_property", "remove"});
        testNode.removePermission(IdentityConstants.ANY);
        this.session.save();
        testNode.checkin();
        testNode.checkout();
        this.session.save();
        String request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:acl xmlns:D=\"DAV:\"><D:ace><D:principal><D:all /></D:principal><D:grant><D:privilege><D:all/></D:privilege></D:grant></D:ace></D:acl>";
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Depth", (Object)"0");
        headers.putSingle((Object)"Content-Type", (Object)"text/xml; charset=\"utf-8\"");
        EnvironmentContext ctx = new EnvironmentContext();
        HashSet<String> adminRoles = new HashSet<String>();
        adminRoles.add("administrators");
        DummySecurityContext adminSecurityContext = new DummySecurityContext(new Principal(){

            @Override
            public String getName() {
                return "root";
            }
        }, adminRoles);
        ctx.put(SecurityContext.class, (Object)adminSecurityContext);
        RequestHandlerImpl handler = (RequestHandlerImpl)this.container.getComponentInstanceOfType(RequestHandlerImpl.class);
        ResourceLauncher launcher = new ResourceLauncher((RequestHandler)handler);
        ContainerResponse response = launcher.service("ACL", this.escape(this.getPathWS() + testNode.getPath()), "http://localhost", (Map)headers, request.getBytes(), null, ctx);
        TestAclCommand.assertEquals((int)200, (int)response.getStatus());
        this.session.refresh(false);
        testNode = (NodeImpl)this.root.getNode(this.TEST_NODE_NAME + "[2]");
        this.checkPermissionSet(testNode, IdentityConstants.ANY, "add_node");
        this.checkPermissionSet(testNode, IdentityConstants.ANY, "set_property");
        this.checkPermissionSet(testNode, IdentityConstants.ANY, "remove");
        this.checkPermissionSet(testNode, IdentityConstants.ANY, "read");
        testNode.remove();
        this.session.save();
    }

    public void testSetAclForVersionableCheckedInNode() throws Exception {
        this.root.addNode(this.TEST_NODE_NAME);
        NodeImpl testNode = (NodeImpl)this.root.addNode(this.TEST_NODE_NAME, "nt:folder");
        this.session.save();
        testNode.addMixin("mix:versionable");
        this.session.save();
        testNode.checkin();
        testNode.checkout();
        testNode.checkin();
        this.session.save();
        String request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:acl xmlns:D=\"DAV:\"><D:ace><D:principal><D:href>Oksana</D:href></D:principal><D:grant><D:privilege><D:all/></D:privilege></D:grant></D:ace></D:acl>";
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Depth", (Object)"0");
        headers.putSingle((Object)"Content-Type", (Object)"text/xml; charset=\"utf-8\"");
        EnvironmentContext ctx = new EnvironmentContext();
        HashSet<String> adminRoles = new HashSet<String>();
        adminRoles.add("administrators");
        DummySecurityContext adminSecurityContext = new DummySecurityContext(new Principal(){

            @Override
            public String getName() {
                return "root";
            }
        }, adminRoles);
        ctx.put(SecurityContext.class, (Object)adminSecurityContext);
        RequestHandlerImpl handler = (RequestHandlerImpl)this.container.getComponentInstanceOfType(RequestHandlerImpl.class);
        ResourceLauncher launcher = new ResourceLauncher((RequestHandler)handler);
        ContainerResponse response = launcher.service("ACL", this.escape(this.getPathWS() + testNode.getPath()), "http://localhost", (Map)headers, request.getBytes(), null, ctx);
        TestAclCommand.assertEquals((int)200, (int)response.getStatus());
        this.session.refresh(false);
        testNode = (NodeImpl)this.root.getNode(this.TEST_NODE_NAME + "[2]");
        this.checkPermissionSet(testNode, "Oksana", "add_node");
        this.checkPermissionSet(testNode, "Oksana", "set_property");
        this.checkPermissionSet(testNode, "Oksana", "remove");
        this.checkPermissionSet(testNode, "Oksana", "read");
        testNode.remove();
        this.session.save();
    }

    public void testSetAclForVersionableOwneablePrivilegeableCheckedInNode() throws Exception {
        this.root.addNode(this.TEST_NODE_NAME);
        NodeImpl testNode = (NodeImpl)this.root.addNode(this.TEST_NODE_NAME, "nt:folder");
        this.session.save();
        testNode.addMixin("exo:owneable");
        testNode.addMixin("exo:privilegeable");
        testNode.addMixin("mix:versionable");
        testNode.setPermission("root", new String[]{"read", "add_node", "set_property", "remove"});
        testNode.removePermission(IdentityConstants.ANY);
        this.session.save();
        testNode.checkin();
        testNode.checkout();
        testNode.checkin();
        this.session.save();
        String request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:acl xmlns:D=\"DAV:\"><D:ace><D:principal><D:all /></D:principal><D:grant><D:privilege><D:all/></D:privilege></D:grant></D:ace></D:acl>";
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Depth", (Object)"0");
        headers.putSingle((Object)"Content-Type", (Object)"text/xml; charset=\"utf-8\"");
        EnvironmentContext ctx = new EnvironmentContext();
        HashSet<String> adminRoles = new HashSet<String>();
        adminRoles.add("administrators");
        DummySecurityContext adminSecurityContext = new DummySecurityContext(new Principal(){

            @Override
            public String getName() {
                return "root";
            }
        }, adminRoles);
        ctx.put(SecurityContext.class, (Object)adminSecurityContext);
        RequestHandlerImpl handler = (RequestHandlerImpl)this.container.getComponentInstanceOfType(RequestHandlerImpl.class);
        ResourceLauncher launcher = new ResourceLauncher((RequestHandler)handler);
        ContainerResponse response = launcher.service("ACL", this.escape(this.getPathWS() + testNode.getPath()), "http://localhost", (Map)headers, request.getBytes(), null, ctx);
        TestAclCommand.assertEquals((int)200, (int)response.getStatus());
        this.session.refresh(false);
        testNode = (NodeImpl)this.root.getNode(this.TEST_NODE_NAME + "[2]");
        this.checkPermissionSet(testNode, IdentityConstants.ANY, "add_node");
        this.checkPermissionSet(testNode, IdentityConstants.ANY, "set_property");
        this.checkPermissionSet(testNode, IdentityConstants.ANY, "remove");
        this.checkPermissionSet(testNode, IdentityConstants.ANY, "read");
        testNode.remove();
        this.session.save();
    }

    private void checkPermissionSet(NodeImpl node, String identity, String permission) throws RepositoryException {
        for (AccessControlEntry entry : node.getACL().getPermissionEntries()) {
            if (!entry.getIdentity().equals(identity) || !entry.getPermission().equals(permission)) continue;
            return;
        }
        TestAclCommand.fail();
    }

    private void checkPermissionRemoved(NodeImpl node, String identity, String permission) throws RepositoryException {
        for (AccessControlEntry entry : node.getACL().getPermissionEntries()) {
            if (!entry.getIdentity().equals(identity) || !entry.getPermission().equals(permission)) continue;
            TestAclCommand.fail();
        }
    }

    @Override
    protected String getRepositoryName() {
        return null;
    }
}

