/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.deltav;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import org.exoplatform.services.jcr.webdav.BaseStandaloneTest;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.utils.TestUtils;

public class TestGetByVersion
extends BaseStandaloneTest {
    private Node getByVersionNode;

    private void assertResponseContent(String path, String versionName, String content) throws IOException, VersionException, UnsupportedRepositoryOperationException, PathNotFoundException, RepositoryException {
        Version version = this.session.getRootNode().getNode(TextUtil.relativizePath((String)path)).getVersionHistory().getVersion(versionName);
        String receivedContent = version.getNode("jcr:frozenNode").getNode("jcr:content").getProperty("jcr:data").getString();
        TestGetByVersion.assertEquals((String)content, (String)receivedContent);
    }

    public void testGetByVersion1() throws Exception {
        String CONTENT1 = "TEST BASE FILE CONTENT..";
        String CONTENT2 = "TEST CONTENT FOR SECOND VERSION..";
        String CONTENT3 = "TEST CONTENT FOR THIRD VERSION OF THE FILE..";
        String path = TestUtils.getFileName();
        Node node = TestUtils.addContent((Session)this.session, path, new ByteArrayInputStream(CONTENT1.getBytes()), this.defaultFileNodeType, "text/plain");
        this.createVersion(node, new ByteArrayInputStream(CONTENT2.getBytes()), "text/plain", new ArrayList<String>());
        this.createVersion(node, new ByteArrayInputStream(CONTENT3.getBytes()), "text/plain", new ArrayList<String>());
        this.assertResponseContent(path, "1", CONTENT1);
        this.assertResponseContent(path, "2", CONTENT2);
        this.assertResponseContent(path, "3", CONTENT3);
    }

    private final void createVersion(Node fileNode, InputStream inputStream, String mimeType, List<String> mixins) throws RepositoryException {
        if (!fileNode.isNodeType("mix:versionable")) {
            if (fileNode.canAddMixin("mix:versionable")) {
                fileNode.addMixin("mix:versionable");
                fileNode.getSession().save();
            }
            fileNode.checkin();
            fileNode.getSession().save();
        }
        if (!fileNode.isCheckedOut()) {
            fileNode.checkout();
            fileNode.getSession().save();
        }
        this.updateContent(fileNode, inputStream, mimeType, mixins);
        fileNode.getSession().save();
        fileNode.checkin();
        fileNode.getSession().save();
    }

    private final void updateContent(Node node, InputStream inputStream, String mimeType, List<String> mixins) throws RepositoryException {
        Node content = node.getNode("jcr:content");
        content.setProperty("jcr:mimeType", mimeType);
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:data", inputStream);
        while (mixins.iterator().hasNext()) {
            content.addMixin(mixins.iterator().next());
        }
    }

    @Override
    protected String getRepositoryName() {
        return null;
    }
}

