/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.deltav.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.namespace.QName;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.BaseStandaloneTest;
import org.exoplatform.services.jcr.webdav.command.deltav.report.VersionTreeResponseEntity;
import org.exoplatform.services.jcr.webdav.util.DeltaVConstants;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.utils.TestUtils;
import org.exoplatform.services.jcr.webdav.utils.WebDavProperty;
import org.exoplatform.services.jcr.webdav.utils.XmlUtils;
import org.exoplatform.services.rest.ext.provider.HierarchicalPropertyEntityProvider;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

public class TestVersionTreeReport
extends BaseStandaloneTest {
    public void testVersionTreeReport() throws Exception {
        this.testVersionTreeReport(this.getPathWS());
    }

    public void testVersionTreeReportWithFakePathWS() throws Exception {
        this.testVersionTreeReport(this.getFakePathWS());
    }

    private void testVersionTreeReport(String pathWs) throws Exception {
        String content;
        String path = TestUtils.getFileName();
        Node node = TestUtils.addContent((Session)this.session, path, new ByteArrayInputStream((content = TestUtils.getFileContent()).getBytes()), this.defaultFileNodeType, "text/xml");
        if (!node.isNodeType("mix:versionable")) {
            node.addMixin("mix:versionable");
            this.session.save();
        }
        node.checkin();
        Object xml = "<?xml version=\"1.0\"?>";
        xml = (String)xml + "<D:version-tree xmlns:D=\"DAV:\">";
        xml = (String)xml + "<D:prop>";
        xml = (String)xml + "<D:version-name/>";
        xml = (String)xml + "<D:successor-set/>";
        xml = (String)xml + "<D:predecessor-set/>";
        xml = (String)xml + "<D:checked-in />";
        xml = (String)xml + "<D:getcontentlength />";
        xml = (String)xml + "<D:resourcetype />";
        xml = (String)xml + "<D:creationdate />";
        xml = (String)xml + "<D:gelastmodified />";
        xml = (String)xml + "</D:prop>";
        xml = (String)xml + "</D:version-tree>";
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"depth", (Object)"1");
        ContainerResponse response = this.service("REPORT", pathWs + path, "", (MultivaluedMap<String, String>)headers, ((String)xml).getBytes());
        TestVersionTreeReport.assertEquals((int)207, (int)response.getStatus());
        VersionTreeResponseEntity entity = (VersionTreeResponseEntity)response.getEntity();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        entity.write((OutputStream)outputStream);
        String resp = outputStream.toString();
        HierarchicalPropertyEntityProvider entityProvider = new HierarchicalPropertyEntityProvider();
        HierarchicalProperty multistatus = entityProvider.readFrom(null, null, null, null, null, (InputStream)new ByteArrayInputStream(resp.getBytes()));
        TestVersionTreeReport.assertEquals((int)1, (int)multistatus.getChildren().size());
        HierarchicalProperty responseProperty = multistatus.getChild(0);
        HierarchicalProperty href = responseProperty.getChild(new QName("DAV:", "href"));
        String hrefMustBe = TextUtil.escape((String)(this.getPathWS() + path + "?version=1"), (char)'%', (boolean)true);
        TestVersionTreeReport.assertEquals((String)hrefMustBe, (String)href.getValue());
        Map<QName, WebDavProperty> properties = XmlUtils.parsePropStat(responseProperty);
        WebDavProperty versionName = properties.get(DeltaVConstants.VERSIONNAME);
        TestVersionTreeReport.assertNotNull((Object)((Object)versionName));
        TestVersionTreeReport.assertEquals((int)200, (int)versionName.getStatus());
        TestVersionTreeReport.assertEquals((String)"1", (String)versionName.getValue());
        WebDavProperty checkedIn = properties.get(DeltaVConstants.CHECKEDIN);
        TestVersionTreeReport.assertNotNull((Object)((Object)checkedIn));
        TestVersionTreeReport.assertEquals((int)200, (int)checkedIn.getStatus());
        TestVersionTreeReport.assertEquals((String)hrefMustBe, (String)checkedIn.getChild(0).getValue());
        WebDavProperty predecessorSet = properties.get(DeltaVConstants.PREDECESSORSET);
        TestVersionTreeReport.assertNotNull((Object)((Object)predecessorSet));
        TestVersionTreeReport.assertEquals((int)200, (int)predecessorSet.getStatus());
        WebDavProperty successorSet = properties.get(DeltaVConstants.SUCCESSORSET);
        TestVersionTreeReport.assertNotNull((Object)((Object)successorSet));
        TestVersionTreeReport.assertEquals((int)200, (int)successorSet.getStatus());
        WebDavProperty resourceType = properties.get(DeltaVConstants.RESOURCETYPE);
        TestVersionTreeReport.assertNotNull((Object)((Object)resourceType));
        TestVersionTreeReport.assertEquals((int)200, (int)resourceType.getStatus());
        WebDavProperty getContentLength = properties.get(DeltaVConstants.GETCONTENTLENGTH);
        TestVersionTreeReport.assertNotNull((Object)((Object)getContentLength));
        TestVersionTreeReport.assertEquals((int)200, (int)getContentLength.getStatus());
        TestVersionTreeReport.assertEquals((int)content.length(), (int)Integer.parseInt(getContentLength.getValue()));
    }

    @Override
    protected String getRepositoryName() {
        return null;
    }
}

