/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.exoplatform.services.jcr.webdav.BaseStandaloneTest;
import org.exoplatform.services.jcr.webdav.command.dasl.SearchResultResponseEntity;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.utils.TestUtils;
import org.exoplatform.services.rest.impl.ContainerResponse;

public class TestSearch
extends BaseStandaloneTest {
    private String fileName = TestUtils.getFileName();
    private final String fileContent = "TEST FILE CONTENT...";
    private final String basicSql = "<D:searchrequest xmlns:D='DAV:'><D:sql>SELECT * FROM  nt:resource WHERE contains(*, 'TEST')</D:sql></D:searchrequest>";
    private final String pathSql = "<D:searchrequest xmlns:D='DAV:'><D:sql>SELECT * FROM nt:base WHERE jcr:path LIKE '/node[%]/%'</D:sql></D:searchrequest>";

    public void testBasicSearch() throws Exception {
        this.testBasicSearch(this.getPathWS());
    }

    public void testBasicSearchWithFakePathWS() throws Exception {
        this.testBasicSearch(this.getFakePathWS());
    }

    private void testBasicSearch(String pathWs) throws Exception {
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)this.fileName));
        ByteArrayInputStream inputStream = new ByteArrayInputStream("TEST FILE CONTENT...".getBytes());
        TestUtils.addContent((Session)this.session, this.fileName, inputStream, this.defaultFileNodeType, "text/plain");
        ContainerResponse response = this.service("SEARCH", pathWs, "", null, "<D:searchrequest xmlns:D='DAV:'><D:sql>SELECT * FROM  nt:resource WHERE contains(*, 'TEST')</D:sql></D:searchrequest>".getBytes());
        TestSearch.assertEquals((int)207, (int)response.getStatus());
        SearchResultResponseEntity entity = (SearchResultResponseEntity)response.getEntity();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        entity.write((OutputStream)outputStream);
        String result = outputStream.toString();
        TestSearch.assertTrue((boolean)result.contains(this.fileName));
    }

    public void testPathSearch() throws Exception {
        Node testRoot = this.session.getRootNode().addNode("node", this.defaultFolderNodeType);
        Node node = testRoot.addNode("addedNode", this.defaultFileNodeType);
        node.addNode("jcr:content", "nt:resource");
        Node content = node.getNode("jcr:content");
        content.setProperty("jcr:mimeType", "text/plain");
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:data", (InputStream)new ByteArrayInputStream("Text".getBytes()));
        this.session.save();
        ContainerResponse response = this.service("SEARCH", this.getPathWS(), "", null, "<D:searchrequest xmlns:D='DAV:'><D:sql>SELECT * FROM nt:base WHERE jcr:path LIKE '/node[%]/%'</D:sql></D:searchrequest>".getBytes());
        SearchResultResponseEntity entity = (SearchResultResponseEntity)response.getEntity();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        entity.write((OutputStream)outputStream);
        outputStream.toByteArray();
        List<String> found = this.parseNodeNames(outputStream.toByteArray());
        TestSearch.assertEquals((int)1, (int)found.size());
    }

    public void testBasicSearchWithNonLatin() throws Exception {
        String encodedfileName = "%e3%81%82%e3%81%84%e3%81%86%e3%81%88%e3%81%8a";
        String decodedfileName = URLDecoder.decode(encodedfileName, "UTF-8");
        ByteArrayInputStream inputStream = new ByteArrayInputStream("TEST FILE CONTENT...".getBytes());
        TestUtils.addContent((Session)this.session, decodedfileName, inputStream, this.defaultFileNodeType, "text/plain");
        ContainerResponse response = this.service("SEARCH", this.getPathWS(), "", null, "<D:searchrequest xmlns:D='DAV:'><D:sql>SELECT * FROM  nt:resource WHERE contains(*, 'TEST')</D:sql></D:searchrequest>".getBytes());
        SearchResultResponseEntity entity = (SearchResultResponseEntity)response.getEntity();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        entity.write((OutputStream)outputStream);
        String resp = outputStream.toString("UTF-8");
        TestSearch.assertTrue((boolean)resp.contains(encodedfileName));
        TestSearch.assertTrue((boolean)resp.contains(decodedfileName));
    }

    @Override
    protected String getRepositoryName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> parseNodeNames(byte[] data) throws XMLStreamException, FactoryConfigurationError, IOException {
        displayName = false;
        nodes = new ArrayList<String>();
        input = new ByteArrayInputStream(data);
        reader = XMLInputFactory.newInstance().createXMLStreamReader(input);
        name = QName.valueOf("{DAV:}href");
lbl6:
        // 3 sources

        try {
            block7: while (reader.hasNext()) {
                eventCode = reader.next();
                switch (eventCode) {
                    case 1: {
                        if (!reader.getName().equals(name)) continue block7;
                        displayName = true;
                        ** GOTO lbl6
                    }
                    case 4: {
                        if (!displayName || (nodeName = reader.getText()) == null || nodeName.equals("")) continue block7;
                        nodes.add(nodeName);
                        ** GOTO lbl6
                    }
                }
                displayName = false;
            }
            return new ArrayList<String>(nodes);
        }
        finally {
            reader.close();
            input.close();
        }
    }
}

