/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.io.ByteArrayInputStream;
import javax.jcr.Session;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.services.jcr.webdav.BaseStandaloneTest;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.utils.TestUtils;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

public class TestDelete
extends BaseStandaloneTest {
    public void testDeleteForNonCollection() throws Exception {
        this.testDeleteForNonCollection(this.getPathWS());
    }

    public void testDeleteForNonCollectionWithFakePathWS() throws Exception {
        this.testDeleteForNonCollection(this.getFakePathWS());
    }

    private void testDeleteForNonCollection(String pathWs) throws Exception {
        Object path = TestUtils.getFileName();
        String fileContent = TestUtils.getFileContent();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)path));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(fileContent.getBytes());
        TestUtils.addContent((Session)this.session, (String)path, inputStream, this.defaultFileNodeType, "");
        path = (String)path + "[2]";
        ContainerResponse response = this.serviceWithEscape("DELETE", pathWs + (String)path, "", null, null);
        TestDelete.assertEquals((int)204, (int)response.getStatus());
        TestDelete.assertFalse((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)path)));
    }

    public void testDeleteForCollection() throws Exception {
        String path = TestUtils.getFileName();
        String fileContent = TestUtils.getFileContent();
        Object folderName = TestUtils.getFolderName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)folderName));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(fileContent.getBytes());
        TestUtils.addFolder((Session)this.session, (String)folderName, this.defaultFolderNodeType, "");
        TestUtils.addContent((Session)this.session, (String)folderName + path, inputStream, this.defaultFileNodeType, "");
        folderName = (String)folderName + "[2]";
        ContainerResponse response = this.serviceWithEscape("DELETE", this.getPathWS() + (String)folderName, "", null, null);
        TestDelete.assertEquals((int)204, (int)response.getStatus());
        TestDelete.assertFalse((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)folderName)));
    }

    public void testDeleteWithLock() throws Exception {
        Object path = TestUtils.getFileName();
        String fileContent = TestUtils.getFileContent();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)path));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(fileContent.getBytes());
        TestUtils.addContent((Session)this.session, (String)path, inputStream, this.defaultFileNodeType, "");
        path = (String)path + "[2]";
        String lockToken = TestUtils.lockNode((Session)this.session, (String)path, true);
        ContainerResponse response = this.serviceWithEscape("DELETE", this.getPathWS() + (String)path, "", null, null);
        TestDelete.assertEquals((int)423, (int)response.getStatus());
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"lock-token", (Object)lockToken);
        response = this.serviceWithEscape("DELETE", this.getPathWS() + (String)path, "", (MultivaluedMap<String, String>)headers, null);
        TestDelete.assertEquals((int)204, (int)response.getStatus());
        TestDelete.assertFalse((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)path)));
    }

    @Override
    protected String getRepositoryName() {
        return null;
    }
}

