/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.resource;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.xml.namespace.QName;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.resource.GenericResource;
import org.exoplatform.services.jcr.webdav.resource.IllegalResourceTypeException;
import org.exoplatform.services.jcr.webdav.resource.VersionResource;
import org.exoplatform.services.jcr.webdav.resource.VersionedResource;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;

public class VersionHistoryResource
extends GenericResource {
    protected final VersionHistory versionHistory;
    protected final VersionedResource versionedResource;

    public VersionHistoryResource(URI identifier, VersionHistory versionHistory, VersionedResource versionedResource, WebDavNamespaceContext namespaceContext) throws IllegalResourceTypeException, RepositoryException {
        super(8, identifier, namespaceContext);
        this.versionHistory = versionHistory;
        this.versionedResource = versionedResource;
    }

    @Override
    public HierarchicalProperty getProperty(QName name) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        return null;
    }

    @Override
    public final boolean isCollection() {
        return false;
    }

    public Set<VersionResource> getVersions() throws RepositoryException, IllegalResourceTypeException {
        HashSet<VersionResource> resources = new HashSet<VersionResource>();
        VersionIterator versions = this.versionHistory.getAllVersions();
        while (versions.hasNext()) {
            Version version = versions.nextVersion();
            if ("jcr:rootVersion".equals(version.getName())) continue;
            resources.add(new VersionResource(this.versionURI(version.getName()), this.versionedResource, version, this.namespaceContext));
        }
        return resources;
    }

    public VersionResource getVersion(String name) throws RepositoryException, IllegalResourceTypeException {
        return new VersionResource(this.versionURI(name), this.versionedResource, this.versionHistory.getVersion(name), this.namespaceContext);
    }

    protected final URI versionURI(String versionName) {
        return URI.create(this.versionedResource.getIdentifier().toASCIIString() + "?version=" + versionName);
    }
}

