/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.transform.impl.trax;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.xml.transform.NotSupportedIOTypeException;
import org.exoplatform.services.xml.transform.impl.trax.TRAXTemplatesLoaderPlugin;
import org.exoplatform.services.xml.transform.trax.TRAXTemplates;
import org.exoplatform.services.xml.transform.trax.TRAXTemplatesService;
import org.exoplatform.services.xml.transform.trax.TRAXTransformerService;
import org.picocontainer.Startable;

public class TRAXTemplatesServiceImpl
implements TRAXTemplatesService,
Startable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.xml-processing.TRAXTemplatesServiceImpl");
    private Map<String, TRAXTemplates> templates_;
    private TRAXTransformerService traxTransformerService_;

    public TRAXTemplatesServiceImpl(TRAXTransformerService traxTransformerService) {
        this.traxTransformerService_ = traxTransformerService;
        this.templates_ = new HashMap<String, TRAXTemplates>();
    }

    @Override
    public TRAXTemplates getTemplates(String key) {
        return this.templates_.get(key);
    }

    @Override
    public void addTRAXTemplates(String key, TRAXTemplates templates) throws IllegalArgumentException {
        if (this.templates_.get(key) != null) {
            throw new IllegalArgumentException("Templates with key '" + key + "' already exists!");
        }
        this.templates_.put(key, templates);
    }

    @Override
    public void addTRAXTemplates(String key, Source source) throws IllegalArgumentException {
        if (this.templates_.get(key) != null) {
            throw new IllegalArgumentException("Templates with key '" + key + "' already exists!");
        }
        try {
            this.templates_.put(key, this.traxTransformerService_.getTemplates(source));
        }
        catch (NotSupportedIOTypeException e) {
            throw new IllegalArgumentException("Source has unsupported context." + String.valueOf(e), e);
        }
        catch (TransformerException e) {
            throw new IllegalArgumentException("Can't get templates from source." + String.valueOf(e), e);
        }
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof TRAXTemplatesLoaderPlugin) {
            Map<String, String> m = ((TRAXTemplatesLoaderPlugin)plugin).getTRAXTemplates();
            Set<String> keys = m.keySet();
            for (String key : keys) {
                String xsltSchema = m.get(key);
                try {
                    if (Thread.currentThread().getContextClassLoader().getResource(xsltSchema) != null) {
                        LOG.info((Object)("XSLT schema found by relative path: " + xsltSchema));
                        this.addTRAXTemplates(key, this.traxTransformerService_.getTemplates(new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream(xsltSchema))));
                        continue;
                    }
                    LOG.error((Object)("XSLT schema not found: " + xsltSchema));
                }
                catch (IllegalArgumentException e) {
                    LOG.error((Object)("Add new TRAXTemplates failed : " + e.getMessage()));
                }
                catch (TransformerException e) {
                    LOG.error((Object)("Add new TRAXTemplates failed : " + e.getMessage()));
                }
                catch (NotSupportedIOTypeException e) {
                    LOG.error((Object)("Add new TRAXTemplates failed : " + e.getMessage()));
                }
            }
        }
    }

    public void start() {
    }

    public void stop() {
    }
}

