/*
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.frameworks.jcr.command.ext;

import javax.jcr.Node;
import javax.jcr.Session;

import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.exoplatform.frameworks.jcr.command.DefaultKeys;
import org.exoplatform.frameworks.jcr.command.JCRAppContext;
import org.exoplatform.frameworks.jcr.command.JCRCommandHelper;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author <a href="mailto:gennady.azarenkov@exoplatform.com">Gennady Azarenkov</a>
 * @version $Id: AddResourceFileCommand.java 35179 2009-08-07 13:58:20Z pnedonosko $
 */

public class AddResourceFileCommand implements Command {

  private String pathKey        = DefaultKeys.PATH;

  private String currentNodeKey = DefaultKeys.CURRENT_NODE;

  private String resultKey      = DefaultKeys.RESULT;

  private String dataKey        = "data";

  private String mimeTypeKey    = "mimeType";

  public boolean execute(Context context) throws Exception {

    Session session = ((JCRAppContext) context).getSession();

    Node parentNode = (Node) session.getItem((String) context.get(currentNodeKey));
    String relPath = (String) context.get(pathKey);
    Object data = context.get(dataKey);
    String mimeType = (String) context.get(mimeTypeKey);

    Node file = JCRCommandHelper.createResourceFile(parentNode, relPath, data, mimeType);

    // Node file = parentNode.addNode(relPath, "nt:file");
    // Node contentNode = file.addNode("jcr:content", "nt:resource");
    // if(data instanceof InputStream)
    // contentNode.setProperty("jcr:data", (InputStream)data);
    // else
    // contentNode.setProperty("jcr:data", (String)data);
    // contentNode.setProperty("jcr:mimeType",
    // (String)context.get(mimeTypeKey));
    // contentNode.setProperty("jcr:lastModified", session
    // .getValueFactory().createValue(Calendar.getInstance()));

    context.put(resultKey, file);
    return true;
  }

  public String getResultKey() {
    return resultKey;
  }

  public String getCurrentNodeKey() {
    return currentNodeKey;
  }

  public String getPathKey() {
    return pathKey;
  }
}
