/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.frameworks.jcr.JCRAppSessionFactory;
import org.exoplatform.services.jcr.core.ManageableRepository;

public class SingleRepositorySessionFactory
implements JCRAppSessionFactory {
    public static final String SESSION_FACTORY = "org.exoplatform.frameworks.web.sessionFactory";
    private Map<String, Session> cache = new HashMap<String, Session>();
    private Repository rep;
    private Credentials credentials;
    private String defaultWorkspace;

    public SingleRepositorySessionFactory(ManageableRepository repository) {
        this(repository, null);
    }

    public SingleRepositorySessionFactory(ManageableRepository repository, Credentials cred) {
        this.rep = repository;
        this.credentials = cred;
        this.defaultWorkspace = repository.getConfiguration().getDefaultWorkspaceName();
    }

    public Session getSession(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        Session ses;
        if (workspaceName == null || workspaceName.length() == 0) {
            if (this.defaultWorkspace == null) {
                throw new NoSuchWorkspaceException("No workspace found");
            }
            workspaceName = this.defaultWorkspace;
        }
        if ((ses = this.cache.get(workspaceName)) == null) {
            ses = this.credentials == null ? this.rep.login(workspaceName) : this.rep.login(this.credentials, workspaceName);
            this.cache.put(workspaceName, ses);
        }
        return ses;
    }

    public void close() {
        Collection<Session> cachedSessions = this.cache.values();
        for (Session curSession : cachedSessions) {
            curSession.logout();
        }
        this.cache.clear();
    }
}

