/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.command;

import java.util.Iterator;
import javax.jcr.NodeIterator;
import junit.framework.TestCase;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.frameworks.jcr.command.BasicAppContext;
import org.exoplatform.frameworks.jcr.command.core.AddNodeCommand;
import org.exoplatform.frameworks.jcr.command.core.SaveCommand;
import org.exoplatform.services.command.impl.CommandService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;

public class TestJCRCommands
extends TestCase {
    private StandaloneContainer container;
    private CommandService cservice;
    private BasicAppContext ctx;

    public void setUp() throws Exception {
        String containerConf = ((Object)((Object)this)).getClass().getResource("/conf/standalone/test-configuration.xml").toString();
        String loginConf = Thread.currentThread().getContextClassLoader().getResource("login.conf").toString();
        if (System.getProperty("java.security.auth.login.config") == null) {
            System.setProperty("java.security.auth.login.config", loginConf);
        }
        StandaloneContainer.addConfigurationURL((String)containerConf);
        this.container = StandaloneContainer.getInstance();
        RepositoryService repService = (RepositoryService)this.container.getComponentInstanceOfType(RepositoryService.class);
        this.cservice = (CommandService)this.container.getComponentInstanceOfType(CommandService.class);
        Authenticator authr = (Authenticator)this.container.getComponentInstanceOfType(Authenticator.class);
        String validUser = authr.validateUser(new Credential[]{new UsernameCredential("root"), new PasswordCredential("exo")});
        Identity id = authr.createIdentity(validUser);
        ConversationState s = new ConversationState(id);
        ConversationState.setCurrent((ConversationState)s);
        this.ctx = new BasicAppContext(repService.getDefaultRepository());
        this.ctx.getSession().getRootNode().addNode("foo");
        this.ctx.getSession().save();
    }

    public void tearDown() throws Exception {
        if (this.ctx.getSession().getRootNode().hasNode("foo")) {
            this.ctx.getSession().getRootNode().getNode("foo").remove();
            this.ctx.getSession().save();
        }
    }

    public void testCatalogInit() throws Exception {
        Iterator cs = this.cservice.getCatalog().getNames();
        TestJCRCommands.assertTrue((boolean)cs.hasNext());
    }

    public void testAddNode() throws Exception {
        AddNodeCommand addNode = (AddNodeCommand)this.cservice.getCatalog().getCommand("addNode");
        this.ctx.put("currentNode", (Object)"/");
        this.ctx.put(addNode.getPathKey(), (Object)"test");
        addNode.execute((Context)this.ctx);
        SaveCommand save = (SaveCommand)this.cservice.getCatalog().getCommand("save");
        this.ctx.put(addNode.getPathKey(), (Object)"/");
        save.execute((Context)this.ctx);
    }

    public void testSetProperty() throws Exception {
        Command c = this.cservice.getCatalog().getCommand("setProperty");
        this.ctx.put("currentNode", (Object)"/foo");
        this.ctx.put("name", (Object)"testProperty");
        this.ctx.put("propertyType", (Object)"String");
        this.ctx.put("values", (Object)"testValue");
        this.ctx.put("multiValued", (Object)Boolean.FALSE);
        c.execute((Context)this.ctx);
        Command save = this.cservice.getCatalog().getCommand("save");
        save.execute((Context)this.ctx);
    }

    public void testGetNodes() throws Exception {
        Command c = this.cservice.getCatalog().getCommand("getNodes");
        this.ctx.put("currentNode", (Object)"/");
        c.execute((Context)this.ctx);
        TestJCRCommands.assertTrue((boolean)(this.ctx.get((Object)"result") instanceof NodeIterator));
        NodeIterator nodes = (NodeIterator)this.ctx.get((Object)"result");
        TestJCRCommands.assertTrue((nodes.getSize() > 0L ? 1 : 0) != 0);
    }

    public void testAddResourceFile() throws Exception {
        Command c = this.cservice.getCatalog().getCommand("addResourceFile");
        this.ctx.put("currentNode", (Object)"/");
        this.ctx.put("path", (Object)"resource");
        this.ctx.put("data", (Object)"Node data");
        this.ctx.put("mimeType", (Object)"text/html");
        c.execute((Context)this.ctx);
        Command save = this.cservice.getCatalog().getCommand("save");
        this.ctx.put("path", (Object)"/");
        save.execute((Context)this.ctx);
    }

    public void testGetNodeChain() throws Exception {
        Command cmd = this.cservice.getCatalog().getCommand("retrieveNodeCommand");
        this.ctx.put("currentNode", (Object)"/");
        this.ctx.put("path", (Object)"foo");
        cmd.execute((Context)this.ctx);
    }
}

