/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.command.cli;

import java.util.ArrayList;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import junit.framework.TestCase;
import org.apache.commons.chain.Context;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.frameworks.jcr.cli.AddNodeCommand;
import org.exoplatform.frameworks.jcr.cli.CliAppContext;
import org.exoplatform.frameworks.jcr.cli.CopyNodeCommand;
import org.exoplatform.frameworks.jcr.cli.GetContextInfoCommand;
import org.exoplatform.frameworks.jcr.cli.GetItemCommand;
import org.exoplatform.frameworks.jcr.cli.GetNodeCommand;
import org.exoplatform.frameworks.jcr.cli.GetNodesCommand;
import org.exoplatform.frameworks.jcr.cli.GetPropertiesCommand;
import org.exoplatform.frameworks.jcr.cli.GetPropertyCommand;
import org.exoplatform.frameworks.jcr.cli.HelpCommand;
import org.exoplatform.frameworks.jcr.cli.LoginCommand;
import org.exoplatform.frameworks.jcr.cli.MoveNodeCommand;
import org.exoplatform.frameworks.jcr.cli.RemoveItemCommand;
import org.exoplatform.frameworks.jcr.cli.SetPropertyCommand;
import org.exoplatform.services.command.impl.CommandService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;

public class TestJCRClientCommands
extends TestCase {
    private StandaloneContainer container;
    private CommandService cservice;
    private CliAppContext ctx;
    private ArrayList<String> params = new ArrayList();
    private static final String PARAMETERS_KEY = "parametersss";

    public void setUp() throws Exception {
        String containerConf = ((Object)((Object)this)).getClass().getResource("/conf/standalone/test-configuration.xml").toString();
        String loginConf = Thread.currentThread().getContextClassLoader().getResource("login.conf").toString();
        if (System.getProperty("java.security.auth.login.config") == null) {
            System.setProperty("java.security.auth.login.config", loginConf);
        }
        StandaloneContainer.addConfigurationURL((String)containerConf);
        this.container = StandaloneContainer.getInstance();
        RepositoryService repService = (RepositoryService)this.container.getComponentInstanceOfType(RepositoryService.class);
        this.cservice = (CommandService)this.container.getComponentInstanceOfType(CommandService.class);
        Authenticator authr = (Authenticator)this.container.getComponentInstanceOfType(Authenticator.class);
        String validUser = authr.validateUser(new Credential[]{new UsernameCredential("root"), new PasswordCredential("exo")});
        Identity id = authr.createIdentity(validUser);
        ConversationState s = new ConversationState(id);
        ConversationState.setCurrent((ConversationState)s);
        this.ctx = new CliAppContext(repService.getDefaultRepository(), PARAMETERS_KEY);
        Node root = this.ctx.getSession().getRootNode();
        this.ctx.setCurrentItem((Item)root);
        while (root.hasNode("testJCRClientCommands")) {
            root.getNode("testJCRClientCommands").remove();
            root.save();
        }
        Node node = root.addNode("testJCRClientCommands").addNode("childOftestJCRClientCommands");
        node.setProperty("testProperty", "test");
        root.save();
        TestJCRClientCommands.assertNotNull((Object)this.ctx);
    }

    public void testCtxLogin() throws Exception {
        this.params.clear();
        LoginCommand loginCommand = (LoginCommand)this.cservice.getCatalog("CLI").getCommand("login");
        this.params.add("ws");
        this.ctx.put(PARAMETERS_KEY, this.params);
        loginCommand.execute((Context)this.ctx);
        TestJCRClientCommands.assertEquals((Object)this.ctx.getCurrentItem(), (Object)this.ctx.getSession().getRootNode());
        TestJCRClientCommands.assertEquals((String)"ws", (String)this.ctx.getSession().getWorkspace().getName());
    }

    public void testGetCtxItem() throws Exception {
        this.params.clear();
        GetItemCommand getItemCommand = (GetItemCommand)this.cservice.getCatalog("CLI").getCommand("getitem");
        this.params.add("/testJCRClientCommands");
        this.ctx.put(PARAMETERS_KEY, this.params);
        getItemCommand.execute((Context)this.ctx);
        TestJCRClientCommands.assertEquals((String)this.ctx.getCurrentItem().getName(), (String)"testJCRClientCommands");
    }

    public void testGetCtxNode() throws Exception {
        this.params.clear();
        this.ctx.setCurrentItem((Item)this.ctx.getSession().getRootNode().getNode("testJCRClientCommands"));
        GetNodeCommand getNodeCommand = (GetNodeCommand)this.cservice.getCatalog("CLI").getCommand("getnode");
        this.params.add("childOftestJCRClientCommands");
        this.ctx.put(PARAMETERS_KEY, this.params);
        getNodeCommand.execute((Context)this.ctx);
        TestJCRClientCommands.assertEquals((String)this.ctx.getCurrentItem().getName(), (String)"childOftestJCRClientCommands");
    }

    public void testGetCtxProperty() throws Exception {
        this.params.clear();
        this.ctx.setCurrentItem((Item)this.ctx.getSession().getRootNode().getNode("testJCRClientCommands/childOftestJCRClientCommands"));
        GetPropertyCommand getPropertyCommand = (GetPropertyCommand)this.cservice.getCatalog("CLI").getCommand("getproperty");
        this.params.add("testProperty");
        this.ctx.put(PARAMETERS_KEY, this.params);
        getPropertyCommand.execute((Context)this.ctx);
        TestJCRClientCommands.assertEquals((String)((Property)this.ctx.getCurrentItem()).getValue().getString(), (String)"test");
    }

    public void testGetCtxNodes() throws Exception {
        this.params.clear();
        GetItemCommand getItemCommand = (GetItemCommand)this.cservice.getCatalog("CLI").getCommand("getitem");
        this.params.add("/testJCRClientCommands");
        this.ctx.put(PARAMETERS_KEY, this.params);
        getItemCommand.execute((Context)this.ctx);
        GetNodesCommand getNodesCommand = (GetNodesCommand)this.cservice.getCatalog("CLI").getCommand("getnodes");
        getNodesCommand.execute((Context)this.ctx);
        TestJCRClientCommands.assertTrue((boolean)this.ctx.getOutput().contains("childOftestJCRClientCommands"));
    }

    public void testGetCtxProperties() throws Exception {
        GetPropertiesCommand getPropertiesCommand = (GetPropertiesCommand)this.cservice.getCatalog("CLI").getCommand("getproperties");
        getPropertiesCommand.execute((Context)this.ctx);
        TestJCRClientCommands.assertTrue((boolean)this.ctx.getOutput().contains("jcr:primaryType"));
    }

    public void testAddNode1() throws Exception {
        this.params.clear();
        AddNodeCommand addNodeCommand = (AddNodeCommand)this.cservice.getCatalog("CLI").getCommand("addnode");
        this.params.add("childOftestJCRClientCommands1");
        this.ctx.put(PARAMETERS_KEY, this.params);
        addNodeCommand.execute((Context)this.ctx);
        TestJCRClientCommands.assertEquals((String)this.ctx.getCurrentItem().getName(), (String)"childOftestJCRClientCommands1");
    }

    public void testAddNode2() throws Exception {
        this.params.clear();
        AddNodeCommand addNodeCommand = (AddNodeCommand)this.cservice.getCatalog("CLI").getCommand("addnode");
        this.params.add("childOftestJCRClientCommands2");
        this.params.add("nt:unstructured");
        this.ctx.put(PARAMETERS_KEY, this.params);
        addNodeCommand.execute((Context)this.ctx);
        TestJCRClientCommands.assertEquals((String)((Node)this.ctx.getCurrentItem()).getPrimaryNodeType().getName(), (String)"nt:unstructured");
    }

    public void testSetProperty1() throws Exception {
        this.params.clear();
        SetPropertyCommand setPropertyCommand = (SetPropertyCommand)this.cservice.getCatalog("CLI").getCommand("setproperty");
        this.params.add("propertyName1");
        this.params.add("propertyValue1");
        this.ctx.put(PARAMETERS_KEY, this.params);
        setPropertyCommand.execute((Context)this.ctx);
        TestJCRClientCommands.assertEquals((String)((Property)this.ctx.getCurrentItem()).getName(), (String)"propertyName1");
        TestJCRClientCommands.assertEquals((String)((Property)this.ctx.getCurrentItem()).getValue().getString(), (String)"propertyValue1");
    }

    public void testSetProperty2() throws Exception {
        this.params.clear();
        GetItemCommand getItemCommand = (GetItemCommand)this.cservice.getCatalog("CLI").getCommand("getitem");
        this.params.add("..");
        this.ctx.put(PARAMETERS_KEY, this.params);
        getItemCommand.execute((Context)this.ctx);
        this.params.clear();
        SetPropertyCommand setPropertyCommand = (SetPropertyCommand)this.cservice.getCatalog("CLI").getCommand("setproperty");
        this.params.add("propertyName2");
        this.params.add("12345");
        this.params.add(new Integer(3).toString());
        this.ctx.put(PARAMETERS_KEY, this.params);
        setPropertyCommand.execute((Context)this.ctx);
        TestJCRClientCommands.assertEquals((String)((Property)this.ctx.getCurrentItem()).getName(), (String)"propertyName2");
        TestJCRClientCommands.assertEquals((long)((Property)this.ctx.getCurrentItem()).getValue().getLong(), (long)12345L);
    }

    public void testContextInfoCommand() throws Exception {
        GetContextInfoCommand getContextInfoCommand = (GetContextInfoCommand)this.cservice.getCatalog("CLI").getCommand("getcontextinfo");
        getContextInfoCommand.execute((Context)this.ctx);
        TestJCRClientCommands.assertTrue((boolean)this.ctx.getOutput().contains("root"));
        TestJCRClientCommands.assertTrue((boolean)this.ctx.getOutput().contains("ws"));
    }

    public void testRemoveItemCommand() throws Exception {
        this.ctx.setCurrentItem((Item)this.ctx.getSession().getRootNode().getNode("testJCRClientCommands/childOftestJCRClientCommands"));
        RemoveItemCommand removeItemCommand = (RemoveItemCommand)this.cservice.getCatalog("CLI").getCommand("remove");
        removeItemCommand.execute((Context)this.ctx);
        TestJCRClientCommands.assertEquals((String)((Node)this.ctx.getCurrentItem()).getName(), (String)"testJCRClientCommands");
    }

    public void testCopyNodeCommand() throws Exception {
        this.params.clear();
        CopyNodeCommand copyNodeCommand = (CopyNodeCommand)this.cservice.getCatalog("CLI").getCommand("copynode");
        this.params.add("/testJCRClientCommands");
        this.params.add("/copyOftestJCRClientCommands");
        this.ctx.put(PARAMETERS_KEY, this.params);
        copyNodeCommand.execute((Context)this.ctx);
        TestJCRClientCommands.assertNotNull((Object)this.ctx.getSession().getRootNode().getNode("copyOftestJCRClientCommands"));
    }

    public void testMoveNodeCommand() throws Exception {
        this.params.clear();
        MoveNodeCommand moveNodeCommand = (MoveNodeCommand)this.cservice.getCatalog("CLI").getCommand("movenode");
        this.params.add("/testJCRClientCommands");
        this.params.add("/newCopyOftestJCRClientCommands");
        this.ctx.put(PARAMETERS_KEY, this.params);
        moveNodeCommand.execute((Context)this.ctx);
        TestJCRClientCommands.assertNotNull((Object)this.ctx.getSession().getRootNode().getNode("newCopyOftestJCRClientCommands"));
    }

    public void testHelpCommand() throws Exception {
        this.params.clear();
        HelpCommand helpCommand = (HelpCommand)this.cservice.getCatalog("CLI").getCommand("help");
        this.ctx.put(PARAMETERS_KEY, this.params);
        helpCommand.execute((Context)this.ctx);
        TestJCRClientCommands.assertTrue((boolean)this.ctx.getOutput().contains("addnode"));
    }

    public void testCdCommand() throws Exception {
        this.params.clear();
        GetItemCommand getItemCommand1 = (GetItemCommand)this.cservice.getCatalog("CLI").getCommand("getitem");
        this.params.add("/");
        this.ctx.put(PARAMETERS_KEY, this.params);
        getItemCommand1.execute((Context)this.ctx);
        this.params.clear();
        GetItemCommand getItemCommandAbsPath = (GetItemCommand)this.cservice.getCatalog("CLI").getCommand("getitem");
        this.params.add("/testJCRClientCommands");
        this.ctx.put(PARAMETERS_KEY, this.params);
        getItemCommandAbsPath.execute((Context)this.ctx);
        TestJCRClientCommands.assertEquals((String)this.ctx.getCurrentItem().getName(), (String)"testJCRClientCommands");
        this.params.clear();
        GetItemCommand getItemCommand2 = (GetItemCommand)this.cservice.getCatalog("CLI").getCommand("getitem");
        this.params.add("/");
        this.ctx.put(PARAMETERS_KEY, this.params);
        getItemCommand2.execute((Context)this.ctx);
        this.params.clear();
        GetItemCommand getItemCommandRelPath = (GetItemCommand)this.cservice.getCatalog("CLI").getCommand("getitem");
        this.params.add("testJCRClientCommands");
        this.ctx.put(PARAMETERS_KEY, this.params);
        getItemCommandRelPath.execute((Context)this.ctx);
        TestJCRClientCommands.assertEquals((String)this.ctx.getCurrentItem().getName(), (String)"testJCRClientCommands");
    }

    public void testFinallyRemoveNodes() throws Exception {
        Node root = this.ctx.getSession().getRootNode();
        NodeIterator nodeIterator = root.getNodes();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            if (node.getPath().startsWith("/jcr:system")) continue;
            node.remove();
        }
        root.save();
        TestJCRClientCommands.assertTrue((root.getNodes().getSize() == 1L && root.getNode("jcr:system") != null ? 1 : 0) != 0);
    }
}

