/*
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.frameworks.ftpclient.commands;

import org.apache.commons.logging.Log;
import org.exoplatform.frameworks.ftpclient.FtpConst;
import org.exoplatform.frameworks.ftpclient.FtpConst.Commands;
import org.exoplatform.services.log.ExoLogger;

/**
 * Created by The eXo Platform SAS .
 * 
 * @author Vitaly Guly
 * @version $Id: CmdPort.java 35179 2009-08-07 13:58:20Z pnedonosko $
 */

public class CmdPort extends FtpCommandImpl {

  private static Log log = ExoLogger.getLogger(FtpConst.FTP_PREFIX + "CmdPort");

  protected String   host;

  protected int      port;

  public CmdPort(String host, int port) {
    this.host = host;
    this.port = port;
  }

  public int execute() {
    try {

      // this "IF" for tests only. try to get reply 500
      if (host == null) {
        sendCommand(FtpConst.Commands.CMD_PORT);
        return getReply();
      }

      sendCommand(String.format("%s %s,%d,%d",
                                FtpConst.Commands.CMD_PORT,
                                host,
                                port / 256,
                                port % 256).replace('.', ','));
      return getReply();
    } catch (Exception exc) {
      log.info(FtpConst.EXC_MSG + exc.getMessage(), exc);
    }
    return -1;
  }

}
