/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.ftpclient.data;

import java.io.IOException;
import java.io.OutputStream;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FtpSlowOutputStream
extends OutputStream {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.framework.command.FtpSlowOutputStream");
    private OutputStream nativeOutputStream;
    private int bytesPerSec;
    private int blockSize;
    private int writed = 0;

    public FtpSlowOutputStream(OutputStream nativeOutputStream, int bytesPerSec) {
        this.nativeOutputStream = nativeOutputStream;
        this.bytesPerSec = bytesPerSec;
        this.blockSize = bytesPerSec / 10;
    }

    protected void tryWaiting() {
        if (this.writed >= this.blockSize) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exc) {
                LOG.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            }
            this.writed = 0;
        }
    }

    @Override
    public void write(int dataByte) throws IOException {
        this.tryWaiting();
        this.nativeOutputStream.write(dataByte);
        ++this.writed;
    }

    @Override
    public void write(byte[] dataBytes) throws IOException {
        this.write(dataBytes, 0, dataBytes.length);
    }

    @Override
    public void write(byte[] dataBytes, int offset, int len) throws IOException {
        int allWrited = 0;
        int curOffset = offset;
        while (allWrited < len) {
            this.tryWaiting();
            int curBlockSize = this.blockSize - this.writed;
            if (curBlockSize + allWrited > len) {
                curBlockSize = len - allWrited;
            }
            this.nativeOutputStream.write(dataBytes, curOffset, curBlockSize);
            allWrited += curBlockSize;
            this.writed += curBlockSize;
            curOffset += curBlockSize;
        }
    }

    @Override
    public void flush() throws IOException {
        this.nativeOutputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.nativeOutputStream.close();
    }
}

