/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.ftpclient.cmdtests;

import junit.framework.TestCase;
import org.exoplatform.frameworks.ftpclient.FtpTestConfig;
import org.exoplatform.frameworks.ftpclient.Log;
import org.exoplatform.frameworks.ftpclient.client.FtpClientSession;
import org.exoplatform.frameworks.ftpclient.commands.CmdCwd;
import org.exoplatform.frameworks.ftpclient.commands.CmdMkd;
import org.exoplatform.frameworks.ftpclient.commands.CmdPass;
import org.exoplatform.frameworks.ftpclient.commands.CmdRmd;
import org.exoplatform.frameworks.ftpclient.commands.CmdUser;
import org.exoplatform.frameworks.ftpclient.commands.FtpCommand;

public class MKDTest
extends TestCase {
    private static Log log = new Log("MKDTest");

    public void testMKD() throws Exception {
        log.info("Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        CmdMkd cmdMkd = new CmdMkd("");
        MKDTest.assertEquals((int)530, (int)client.executeCommand((FtpCommand)cmdMkd));
        CmdUser cmdUser = new CmdUser("admin");
        MKDTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)cmdUser));
        CmdPass cmdPass = new CmdPass("admin");
        MKDTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)cmdPass));
        cmdMkd = new CmdMkd("");
        MKDTest.assertEquals((int)500, (int)client.executeCommand((FtpCommand)cmdMkd));
        cmdMkd = new CmdMkd("myfolder");
        MKDTest.assertEquals((int)550, (int)client.executeCommand((FtpCommand)cmdMkd));
        CmdCwd cmdCwd = new CmdCwd("production");
        MKDTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)cmdCwd));
        String folderName = "test_folder_" + System.currentTimeMillis();
        CmdMkd cmdMkd2 = new CmdMkd(folderName);
        MKDTest.assertEquals((int)257, (int)client.executeCommand((FtpCommand)cmdMkd2));
        CmdRmd cmdRmd = new CmdRmd(folderName);
        MKDTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)cmdRmd));
        client.close();
        log.info("Complete.\r\n");
    }

    public void testForbiddenCharsMKD() throws Exception {
        log.info("Test...");
        FtpClientSession client = FtpTestConfig.getTestFtpClient();
        client.connect();
        CmdUser cmdUser = new CmdUser("admin");
        MKDTest.assertEquals((int)331, (int)client.executeCommand((FtpCommand)cmdUser));
        CmdPass cmdPass = new CmdPass("admin");
        MKDTest.assertEquals((int)230, (int)client.executeCommand((FtpCommand)cmdPass));
        CmdCwd cmdCwd = new CmdCwd("production");
        MKDTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)cmdCwd));
        String folderName = "test_folder_123:[]*'\"|123";
        CmdMkd cmdMkd = new CmdMkd(folderName);
        MKDTest.assertEquals((int)257, (int)client.executeCommand((FtpCommand)cmdMkd));
        CmdRmd cmdRmd = new CmdRmd("test_folder_123_______123");
        MKDTest.assertEquals((int)250, (int)client.executeCommand((FtpCommand)cmdRmd));
        client.close();
        log.info("Complete.\r\n");
    }
}

