/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.ftpclient.multimulti;

import junit.framework.TestCase;
import org.exoplatform.frameworks.ftpclient.Log;
import org.exoplatform.frameworks.ftpclient.client.FtpClientSession;
import org.exoplatform.frameworks.ftpclient.client.FtpClientSessionImpl;
import org.exoplatform.frameworks.ftpclient.commands.CmdCwd;
import org.exoplatform.frameworks.ftpclient.commands.CmdDele;
import org.exoplatform.frameworks.ftpclient.commands.CmdMkd;
import org.exoplatform.frameworks.ftpclient.commands.CmdPass;
import org.exoplatform.frameworks.ftpclient.commands.CmdPasv;
import org.exoplatform.frameworks.ftpclient.commands.CmdPwd;
import org.exoplatform.frameworks.ftpclient.commands.CmdRetr;
import org.exoplatform.frameworks.ftpclient.commands.CmdStor;
import org.exoplatform.frameworks.ftpclient.commands.CmdSyst;
import org.exoplatform.frameworks.ftpclient.commands.CmdUser;
import org.exoplatform.frameworks.ftpclient.commands.FtpCommand;
import org.exoplatform.frameworks.ftpclient.multimulti.MultiThreadCrushTest;

public class TestAgent
extends TestCase {
    public static final int SLEEP = 100;
    private Log log;
    private int agentId;
    private int itemsCount;
    private ClientThread clientThread;
    private boolean successed = false;
    private String fName;

    public TestAgent(String name) {
        this.fName = name;
    }

    public TestAgent(int agentId, int itemsCount) {
        this.log = new Log("TestAgent[" + agentId + "]");
        this.agentId = agentId;
        this.itemsCount = itemsCount;
        this.log.info("construct agent with ID [" + agentId + "]");
        this.clientThread = new ClientThread();
        this.clientThread.start();
    }

    public boolean isAlive() {
        return this.clientThread.isAlive();
    }

    public boolean isSuccessed() {
        return this.successed;
    }

    private class ClientThread
    extends Thread {
        private Log log;
        private FtpClientSession client;

        public ClientThread() {
            this.log = new Log("ClientThread[" + TestAgent.this.agentId + "]");
        }

        @Override
        public void run() {
            try {
                String tf1Name;
                int i1;
                while (MultiThreadCrushTest.IsNeedWaitAll) {
                    Thread.sleep(1000L);
                }
                this.client = new FtpClientSessionImpl("localhost", 2121);
                if (!this.client.connect(60)) {
                    return;
                }
                CmdUser cmdUser = new CmdUser("admin");
                TestCase.assertEquals((int)331, (int)this.client.executeCommand((FtpCommand)cmdUser));
                Thread.sleep(100L);
                CmdPass cmdPass = new CmdPass("admin");
                TestCase.assertEquals((int)230, (int)this.client.executeCommand((FtpCommand)cmdPass));
                Thread.sleep(100L);
                CmdSyst cmdSyst = new CmdSyst();
                TestCase.assertEquals((int)215, (int)this.client.executeCommand((FtpCommand)cmdSyst));
                Thread.sleep(100L);
                CmdPwd cmdPwd = new CmdPwd();
                TestCase.assertEquals((int)257, (int)this.client.executeCommand((FtpCommand)cmdPwd));
                Thread.sleep(100L);
                CmdCwd cmdCwd = new CmdCwd("/production/crash_test2");
                TestCase.assertEquals((int)250, (int)this.client.executeCommand((FtpCommand)cmdCwd));
                Thread.sleep(100L);
                cmdPwd = new CmdPwd();
                TestCase.assertEquals((int)257, (int)this.client.executeCommand((FtpCommand)cmdPwd));
                TestCase.assertEquals((String)"/production/crash_test2", (String)cmdPwd.getCurrentPath());
                Thread.sleep(100L);
                String folderName = "" + TestAgent.this.agentId;
                String folder1Name = folderName.substring(0, 1);
                this.log.info("FOLDER 1 NAME: [" + folder1Name + "]");
                CmdCwd cmdCwd2 = new CmdCwd(folder1Name);
                TestCase.assertEquals((int)250, (int)this.client.executeCommand((FtpCommand)cmdCwd2));
                Thread.sleep(100L);
                String folder2Name = folderName.substring(1, 2);
                CmdCwd cmdCwd3 = new CmdCwd(folder2Name);
                TestCase.assertEquals((int)250, (int)this.client.executeCommand((FtpCommand)cmdCwd3));
                Thread.sleep(100L);
                CmdMkd cmdMkd = new CmdMkd(folderName);
                TestCase.assertEquals((int)257, (int)this.client.executeCommand((FtpCommand)cmdMkd, 257, 3));
                Thread.sleep(100L);
                cmdCwd3 = new CmdCwd(folderName);
                TestCase.assertEquals((int)250, (int)this.client.executeCommand((FtpCommand)cmdCwd3));
                Thread.sleep(100L);
                String folderPath = "/production/crash_test2/" + folder1Name + "/" + folder2Name + "/" + folderName;
                this.log.info("FOLDER PATH: [" + folderPath + "]");
                CmdPwd cmdPwd2 = new CmdPwd();
                TestCase.assertEquals((int)257, (int)this.client.executeCommand((FtpCommand)cmdPwd2));
                TestCase.assertEquals((String)folderPath, (String)cmdPwd2.getCurrentPath());
                Thread.sleep(100L);
                for (i1 = 0; i1 < TestAgent.this.itemsCount; ++i1) {
                    tf1Name = "test_folder_" + i1;
                    CmdMkd cmdMkd2 = new CmdMkd(tf1Name);
                    TestCase.assertEquals((int)257, (int)this.client.executeCommand((FtpCommand)cmdMkd2, 257, 3));
                    Thread.sleep(100L);
                    TestCase.assertEquals((int)250, (int)this.client.executeCommand((FtpCommand)new CmdCwd(tf1Name)));
                    Thread.sleep(100L);
                    for (int i2 = 0; i2 < TestAgent.this.itemsCount; ++i2) {
                        int expectReply;
                        String tf2Name = "test_file_" + i2;
                        for (expectReply = 3; expectReply > 0; --expectReply) {
                            int pasvReply = this.client.executeCommand((FtpCommand)new CmdPasv(), 227, 3);
                            if (pasvReply == 227) {
                                byte[] data = new byte[20480];
                                CmdStor cmdStor = new CmdStor(tf2Name);
                                cmdStor.setFileContent(data);
                                int storReply = this.client.executeCommand((FtpCommand)cmdStor);
                                if (storReply == 226) break;
                                Thread.sleep(100L);
                            }
                            Thread.sleep(100L);
                        }
                        if (expectReply != 0) continue;
                        TestCase.fail();
                    }
                    TestCase.assertEquals((int)250, (int)this.client.executeCommand((FtpCommand)new CmdCwd("..")));
                    Thread.sleep(100L);
                }
                for (i1 = 0; i1 < TestAgent.this.itemsCount; ++i1) {
                    tf1Name = "test_folder_" + i1;
                    TestCase.assertEquals((int)250, (int)this.client.executeCommand((FtpCommand)new CmdCwd(tf1Name)));
                    Thread.sleep(100L);
                    for (int i2 = 0; i2 < TestAgent.this.itemsCount; ++i2) {
                        CmdRetr cmdRetr;
                        int retrReply;
                        int pasvReply;
                        String tf2Name = "test_file_" + i2;
                        int expectReply = 3;
                        while (expectReply > 0 && ((pasvReply = this.client.executeCommand((FtpCommand)new CmdPasv(), 227, 3)) != 227 || (retrReply = this.client.executeCommand((FtpCommand)(cmdRetr = new CmdRetr(tf2Name)))) != 226)) {
                        }
                        if (expectReply == 0) {
                            TestCase.fail();
                        }
                        Thread.sleep(100L);
                    }
                    TestCase.assertEquals((int)250, (int)this.client.executeCommand((FtpCommand)new CmdCwd("..")));
                }
                Thread.sleep(100L);
                TestCase.assertEquals((int)250, (int)this.client.executeCommand((FtpCommand)new CmdCwd("..")));
                Thread.sleep(100L);
                TestCase.assertEquals((int)250, (int)this.client.executeCommand((FtpCommand)new CmdDele(folderName)));
                Thread.sleep(100L);
                this.client.close();
                TestAgent.this.successed = true;
            }
            catch (Throwable exc) {
                this.log.info("Unhandled exception. " + exc.getMessage(), exc);
            }
        }
    }
}

