/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.ftpclient.commands;

import org.exoplatform.frameworks.ftpclient.commands.FtpCommandImpl;
import org.exoplatform.frameworks.ftpclient.data.FtpDataTransiverImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CmdPasv
extends FtpCommandImpl {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.framework.command.CmdPasv");
    protected String host = "";
    protected int port = 0;

    @Override
    public int execute() {
        try {
            this.sendCommand("PASV");
            int reply = this.getReply();
            if (227 != reply) {
                return reply;
            }
            String descrVal = this.getDescription();
            descrVal = descrVal.substring(descrVal.indexOf("(") + 1, descrVal.indexOf(")"));
            String[] addrValues = descrVal.split(",");
            this.host = "";
            for (int i = 0; i < 3; ++i) {
                this.host = this.host + addrValues[i] + ".";
            }
            this.host = this.host + addrValues[3];
            this.port = new Integer(addrValues[4]) * 256 + new Integer(addrValues[5]);
            if (227 == reply) {
                FtpDataTransiverImpl dataTransiver = new FtpDataTransiverImpl();
                dataTransiver.OpenPassive(this.host, this.port);
                this.clientSession.setDataTransiver(dataTransiver);
            }
            return reply;
        }
        catch (Exception exc) {
            LOG.info((Object)("unhandled ecxeption. " + exc.getMessage()), (Throwable)exc);
            LOG.info((Object)"SOME ERRORS");
            return -1;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

