/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.webdavclient.documents;

import java.util.ArrayList;
import org.exoplatform.frameworks.webdavclient.XmlUtil;
import org.exoplatform.frameworks.webdavclient.documents.DocumentApi;
import org.exoplatform.frameworks.webdavclient.documents.ResponseDoc;
import org.exoplatform.frameworks.webdavclient.http.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Multistatus
implements DocumentApi {
    protected ArrayList<ResponseDoc> responses = new ArrayList();

    @Override
    public boolean initFromDocument(Document document) {
        try {
            Node documentNode = XmlUtil.getChildNode(document, "multistatus");
            NodeList respNodes = documentNode.getChildNodes();
            for (int i = 0; i < respNodes.getLength(); ++i) {
                Node curResponse = respNodes.item(i);
                String localName = curResponse.getLocalName();
                String nameSpace = curResponse.getNamespaceURI();
                if (localName == null || !"DAV:".equals(nameSpace)) continue;
                ResponseDoc response = new ResponseDoc(curResponse);
                this.responses.add(response);
            }
            return true;
        }
        catch (Exception exc) {
            Log.info("Unhandled exception. " + exc.getMessage());
            exc.printStackTrace();
            return false;
        }
    }

    public ArrayList<ResponseDoc> getResponses() {
        return this.responses;
    }
}

