/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.init;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.StorageDBInitializer;

public class PgSQLDBInitializer
extends StorageDBInitializer {
    public PgSQLDBInitializer(Connection connection, JDBCDataContainerConfig containerConfig) throws IOException {
        super(connection, containerConfig);
    }

    @Override
    protected boolean isTableExists(Connection conn, String tableName) throws SQLException {
        return super.isTableExists(conn, tableName.toUpperCase().toLowerCase());
    }

    @Override
    protected boolean isSequenceExists(final Connection conn, final String sequenceName) throws SQLException {
        return (Boolean)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return PgSQLDBInitializer.this.sequenceExists(sequenceName, conn);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sequenceExists(String sequenceName, Connection con) {
        Statement stmt = null;
        ResultSet trs = null;
        try {
            String query = "SELECT count(*) FROM information_schema.sequences where sequence_name='" + sequenceName.toLowerCase() + "'";
            stmt = con.createStatement();
            trs = stmt.executeQuery(query);
            boolean bl = trs.next() && trs.getInt(1) >= 1;
            JDBCUtils.freeResources((ResultSet)trs, (Statement)stmt, null);
            return bl;
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("SQLException occurs while checking the sequence " + sequenceName), (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            JDBCUtils.freeResources(trs, stmt, null);
        }
    }
}

